/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.block.BlockPicnicMat;
import com.github.tartaricacid.touhoulittlemaid.block.properties.PicnicMatPart;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityPicnicMat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PicnicMatRender
implements BlockEntityRenderer<TileEntityPicnicMat> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/bedrock/block/picnic_mat.png");
    private final SimpleBedrockModel<Entity> model = BedrockModelLoader.getModel(BedrockModelLoader.PICNIC_MAT);
    private final BlockEntityRendererProvider.Context context;

    public PicnicMatRender(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(TileEntityPicnicMat picnicMat, float partialTick, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockState = picnicMat.m_58900_();
        if (((PicnicMatPart)((Object)blockState.m_61143_(BlockPicnicMat.PART))).isCenter() && this.model != null) {
            Direction facing = (Direction)blockState.m_61143_((Property)BlockPicnicMat.FACING);
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 1.5, 0.5);
            poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
            poseStack.m_252781_(Axis.f_252392_.m_252977_((float)(180 - facing.m_122416_() * 90)));
            this.model.getPart((String)"basketHide").visible = !picnicMat.isEmpty(0);
            this.model.getPart((String)"breadHide").visible = !picnicMat.isEmpty(1);
            this.model.getPart((String)"cakeHide").visible = !picnicMat.isEmpty(2);
            this.renderFood(picnicMat, 3, -0.6f, -1.5f, 1.4125f, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
            this.renderFood(picnicMat, 4, 0.15f, -1.2f, 1.4125f, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
            this.renderFood(picnicMat, 5, 0.55f, -1.6f, 1.4125f, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
            this.renderFood(picnicMat, 6, -0.5f, 1.65f, 1.4125f, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
            this.renderFood(picnicMat, 7, 0.375f, 1.575f, 1.4125f, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
            this.renderFood(picnicMat, 8, -0.05f, 1.2f, 1.25f, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
            VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
            this.model.m_7695_(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
    }

    private void renderFood(TileEntityPicnicMat picnicMat, int slotId, float x, float y, float z, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack storageItem = picnicMat.getStorageItem(slotId);
        if (!storageItem.m_41619_()) {
            int count = storageItem.m_41613_();
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
            poseStack.m_252880_(x, y, z);
            poseStack.m_85841_(0.4f, 0.4f, 0.4f);
            this.context.m_234447_().m_269128_(storageItem, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, poseStack, bufferIn, picnicMat.m_58904_(), 0);
            if (count >= 10) {
                int stackCount = count / 10;
                for (int i = 0; i < stackCount; ++i) {
                    poseStack.m_85837_(Math.sin(i) * 0.05, Math.cos(i) * 0.03, -0.07);
                    poseStack.m_252781_(Axis.f_252393_.m_252977_((float)Math.cos(i) * 60.0f));
                    this.context.m_234447_().m_269128_(storageItem, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, poseStack, bufferIn, picnicMat.m_58904_(), 0);
                }
            }
            poseStack.m_85849_();
        }
    }

    public boolean shouldRenderOffScreen(TileEntityPicnicMat te) {
        return true;
    }
}

