/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.builder;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.BaubleManager;
import com.google.common.collect.Maps;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MaidBaubleBuilder {
    private final Map<Item, CustomKubeJSBauble> baubles = Maps.newHashMap();

    @Info(value="Bind an item to a maid bauble. And specify a callback function that will be called every tick of the maid. <br>\n\u5c06\u7269\u54c1\u4e0e\u5973\u4ec6\u9970\u54c1\u7ed1\u5b9a\u3002\u5e76\u4e14\u53ef\u4ee5\u6307\u5b9a\u4e00\u4e2a\u56de\u8c03\u51fd\u6570\uff0c\u5728\u5973\u4ec6\u6bcf\u6b21 tick \u65f6\u8c03\u7528\u3002\n")
    public CustomKubeJSBauble bind(Item item, @Nullable BiConsumer<EntityMaid, ItemStack> onTick) {
        CustomKubeJSBauble bauble = new CustomKubeJSBauble(onTick);
        this.baubles.put(item, bauble);
        return bauble;
    }

    @Info(value="Bind an item to a maid bauble. <br>\n\u5c06\u7269\u54c1\u4e0e\u5973\u4ec6\u9970\u54c1\u7ed1\u5b9a\u3002\n")
    public CustomKubeJSBauble bind(Item item) {
        return this.bind(item, null);
    }

    @HideFromJS
    public void register(BaubleManager manager) {
        this.baubles.forEach(manager::bind);
        this.baubles.clear();
    }

    public static class CustomKubeJSBauble
    implements IMaidBauble {
        private final BiConsumer<EntityMaid, ItemStack> biConsumer;

        public CustomKubeJSBauble(@Nullable BiConsumer<EntityMaid, ItemStack> biConsumer) {
            this.biConsumer = biConsumer;
        }

        @Override
        public void onTick(EntityMaid maid, ItemStack baubleItem) {
            if (this.biConsumer != null) {
                this.biConsumer.accept(maid, baubleItem);
            }
        }
    }
}

