/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task.TaskBuilder;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BaseTaskJS
implements IMaidTask {
    private final Builder builder;

    public BaseTaskJS(Builder builder) {
        this.builder = builder;
    }

    @Override
    public ResourceLocation getUid() {
        return this.builder.id;
    }

    @Override
    public ItemStack getIcon() {
        return this.builder.icon;
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return this.builder.sound;
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        ArrayList tasks = Lists.newArrayList();
        for (Pair pair : this.builder.brains) {
            tasks.add(Pair.of((Object)((Integer)pair.getFirst()), (Object)((BehaviorControl)((BiFunction)pair.getSecond()).apply(this, maid))));
        }
        return tasks;
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        ArrayList tasks = Lists.newArrayList();
        for (Pair pair : this.builder.rideBrains) {
            tasks.add(Pair.of((Object)((Integer)pair.getFirst()), (Object)((BehaviorControl)((BiFunction)pair.getSecond()).apply(this, maid))));
        }
        return tasks;
    }

    @Override
    public boolean isEnable(EntityMaid maid) {
        if (this.builder.enable == null) {
            return IMaidTask.super.isEnable(maid);
        }
        return this.builder.enable.test(maid);
    }

    @Override
    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        if (this.builder.enableLookAndRandomWalk == null) {
            return IMaidTask.super.enableLookAndRandomWalk(maid);
        }
        return this.builder.enableLookAndRandomWalk.test(maid);
    }

    @Override
    public boolean enablePanic(EntityMaid maid) {
        if (this.builder.enablePanic == null) {
            return IMaidTask.super.enablePanic(maid);
        }
        return this.builder.enablePanic.test(maid);
    }

    @Override
    public boolean enableEating(EntityMaid maid) {
        if (this.builder.enableEating == null) {
            return IMaidTask.super.enableEating(maid);
        }
        return this.builder.enableEating.test(maid);
    }

    @Override
    public boolean workPointTask(EntityMaid maid) {
        if (this.builder.workPointTask == null) {
            return IMaidTask.super.workPointTask(maid);
        }
        return this.builder.workPointTask.test(maid);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getEnableConditionDesc(EntityMaid maid) {
        return this.builder.enableConditionDesc;
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return this.builder.conditionDesc;
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        if (this.builder.searchRadius < 0.0f) {
            return IMaidTask.super.searchRadius(maid);
        }
        return this.builder.searchRadius;
    }

    public static class Builder
    extends TaskBuilder<Builder, BaseTaskJS> {
        @Nullable
        private Predicate<EntityMaid> enablePanic = null;
        @Nullable
        private Predicate<EntityMaid> workPointTask = null;
        private float searchRadius = -1.0f;

        public Builder(ResourceLocation id, ItemStack icon) {
            super(id, icon);
        }

        @Info(value="Sets the condition to enable panic behavior for the maid. Default is true. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u662f\u5426\u542f\u7528\u60ca\u614c\u884c\u4e3a\u7684\u6761\u4ef6\u3002\u9ed8\u8ba4\u4e3a true\u3002\n")
        public Builder enablePanic(Predicate<EntityMaid> enablePanic) {
            this.enablePanic = enablePanic;
            return this;
        }

        @Info(value="Sets the condition to enable work point task for the maid. Default is false. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u662f\u5426\u542f\u7528\u5de5\u4f5c\u70b9\u4efb\u52a1\u7684\u6761\u4ef6\u3002\u9ed8\u8ba4\u4e3a false\u3002\n")
        public Builder workPoint(Predicate<EntityMaid> workPointTask) {
            this.workPointTask = workPointTask;
            return this;
        }

        @Info(value="Sets the search radius for the maid's task. Default is the maid's working range. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u4efb\u52a1\u7684\u641c\u7d22\u534a\u5f84\u3002\u9ed8\u8ba4\u4e3a\u5973\u4ec6\u7684\u5de5\u4f5c\u8303\u56f4\u3002\n")
        public Builder searchRadius(float searchRadius) {
            this.searchRadius = searchRadius;
            return this;
        }
    }
}

