/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain;

import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.AIService;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.ZhiZhangAIService;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;

public final class MaidGomokuAI {
    public static final AIService EASY = new ZhiZhangAIService(new AIService.AIConfig(1, 10, false, 0, 6));
    public static final AIService NORMAL = new ZhiZhangAIService(new AIService.AIConfig(4, 10, false, 0, 6));
    public static final AIService HARD = new ZhiZhangAIService(new AIService.AIConfig(6, 10, false, 1, 8));
    public static final AIService HELL = new ZhiZhangAIService(new AIService.AIConfig(8, 10, false, 1, 10));
    public static final int EASY_COUNT = 2;
    public static final int NORMAL_COUNT = 8;
    public static final int HARD_COUNT = 24;

    public static int getRank(EntityMaid maid) {
        int maidCount = maid.getGameRecordManager().getGomokuWinCount();
        if (maidCount <= 2) {
            return 1;
        }
        if (maidCount <= 8) {
            return 2;
        }
        if (maidCount <= 24) {
            return 3;
        }
        return 4;
    }

    public static AIService getService(int winCount) {
        if (winCount <= 2) {
            return EASY;
        }
        if (winCount <= 8) {
            return NORMAL;
        }
        if (winCount <= 24) {
            return HARD;
        }
        return HELL;
    }

    public static Statue getStatue(int[][] chessData, Point point) {
        int nextY;
        int preY;
        int nextY2;
        int preY2;
        int nextX;
        int preX;
        int i;
        int rows = chessData[0].length;
        int cols = chessData.length;
        int x = point.x;
        int y = point.y;
        int type = point.type;
        int k = 1;
        for (i = 1; i < 5 && (preX = x - i) >= 0 && chessData[preX][y] == type; ++i) {
            if (++k != 5) continue;
            return Statue.WIN;
        }
        for (i = 1; i < 5 && (nextX = x + i) <= rows - 1 && chessData[nextX][y] == type; ++i) {
            if (++k != 5) continue;
            return Statue.WIN;
        }
        k = 1;
        for (i = 1; i < 5 && (preY2 = y - i) >= 0 && chessData[x][preY2] == type; ++i) {
            if (++k != 5) continue;
            return Statue.WIN;
        }
        for (i = 1; i < 5 && (nextY2 = y + i) <= cols - 1 && chessData[x][nextY2] == type; ++i) {
            if (++k != 5) continue;
            return Statue.WIN;
        }
        k = 1;
        for (i = 1; i < 5; ++i) {
            preX = x - i;
            preY = y - i;
            if (preX < 0 || preY < 0 || chessData[preX][preY] != type) break;
            if (++k != 5) continue;
            return Statue.WIN;
        }
        for (i = 1; i < 5; ++i) {
            nextX = x + i;
            nextY = y + i;
            if (nextX > rows - 1 || nextY > cols - 1 || chessData[nextX][nextY] != type) break;
            if (++k != 5) continue;
            return Statue.WIN;
        }
        k = 1;
        for (i = 1; i < 5; ++i) {
            nextX = x + i;
            preY = y - i;
            if (nextX > rows - 1 || preY < 0 || chessData[nextX][preY] != type) break;
            if (++k != 5) continue;
            return Statue.WIN;
        }
        for (i = 1; i < 5; ++i) {
            preX = x - i;
            nextY = y + i;
            if (preX < 0 || nextY > cols - 1 || chessData[preX][nextY] != type) break;
            if (++k != 5) continue;
            return Statue.WIN;
        }
        return Statue.IN_PROGRESS;
    }
}

