/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;

public class MaidAttackStrafingAnyItemTask
extends Behavior<EntityMaid> {
    private final Predicate<ItemStack> weaponTest;
    private final float projectileRange;
    private final float strafeSpeed;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public MaidAttackStrafingAnyItemTask(Predicate<ItemStack> weaponTest, float projectileRange, float strafeSpeed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT), 1200);
        this.weaponTest = weaponTest;
        this.projectileRange = projectileRange;
        this.strafeSpeed = strafeSpeed;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        return this.weaponTest.test(owner.m_21205_()) && owner.m_6274_().m_21952_(MemoryModuleType.f_26372_).filter(Entity::m_6084_).isPresent();
    }

    protected void tick(ServerLevel worldIn, EntityMaid owner, long gameTime) {
        if (!this.weaponTest.test(owner.m_21205_())) {
            return;
        }
        owner.m_6274_().m_21952_(MemoryModuleType.f_26372_).ifPresent(target -> {
            double distance = owner.m_20270_((Entity)target);
            this.strafingTime = distance < (double)owner.searchRadius() ? ++this.strafingTime : -1;
            if (this.strafingTime >= 20) {
                if ((double)owner.m_217043_().m_188501_() < 0.3) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)owner.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distance > (double)this.projectileRange * 0.5) {
                    this.strafingBackwards = false;
                } else if (distance < (double)this.projectileRange * 0.2) {
                    this.strafingBackwards = true;
                }
                owner.m_21566_().m_24988_(this.strafingBackwards ? -this.strafeSpeed : this.strafeSpeed, this.strafingClockwise ? this.strafeSpeed : -this.strafeSpeed);
                owner.m_146922_(Mth.m_14094_((float)owner.m_146908_(), (float)owner.f_20885_, (float)0.0f));
                BehaviorUtils.m_22595_((LivingEntity)owner, (LivingEntity)target);
            } else {
                BehaviorUtils.m_22595_((LivingEntity)owner, (LivingEntity)target);
            }
        });
    }

    protected void start(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    protected void stop(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(false);
        entityIn.m_21566_().m_24988_(0.0f, 0.0f);
    }

    protected boolean canStillUse(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        return this.checkExtraStartConditions(worldIn, entityIn);
    }
}

