/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public abstract class MaidMoveToBlockTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 120;
    private final float movementSpeed;
    private final int verticalSearchRange;
    protected int verticalSearchStart;
    private BlockPos currentWorkPos;

    public MaidMoveToBlockTask(float movementSpeed) {
        this(movementSpeed, 1);
    }

    public MaidMoveToBlockTask(float movementSpeed, int verticalSearchRange) {
        this((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT), movementSpeed, verticalSearchRange);
    }

    public MaidMoveToBlockTask(Map<MemoryModuleType<?>, MemoryStatus> requiredMemoryStateIn, float movementSpeed, int verticalSearchRange) {
        super(requiredMemoryStateIn);
        this.movementSpeed = movementSpeed;
        this.verticalSearchRange = verticalSearchRange;
        this.setMaxCheckRate(120);
    }

    protected final void searchForDestination(ServerLevel worldIn, EntityMaid maid) {
        MaidPathFindingBFS pathFinding = this.getOrCreateArrivalMap(worldIn, maid);
        BlockPos centrePos = this.getWorkSearchPos(maid);
        int searchRange = (int)maid.m_21535_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int y = this.verticalSearchStart;
        while (y <= this.verticalSearchRange) {
            for (int i = 0; i < searchRange; ++i) {
                int x = 0;
                while (x <= i) {
                    int z;
                    int n = z = x < i && x > -i ? i : 0;
                    while (z <= i) {
                        mutableBlockPos.m_122154_((Vec3i)centrePos, x, y - 1, z);
                        if (maid.m_21444_((BlockPos)mutableBlockPos) && this.shouldMoveTo(worldIn, maid, (BlockPos)mutableBlockPos) && this.checkPathReach(maid, pathFinding, (BlockPos)mutableBlockPos) && this.checkOwnerPos(maid, (BlockPos)mutableBlockPos)) {
                            BehaviorUtils.m_22617_((LivingEntity)maid, (BlockPos)mutableBlockPos, (float)this.movementSpeed, (int)0);
                            maid.m_6274_().m_21879_((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)new BlockPosTracker((BlockPos)mutableBlockPos));
                            this.currentWorkPos = mutableBlockPos;
                            this.setNextCheckTickCount(5);
                            this.clearCurrentArrivalMap(pathFinding);
                            return;
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
        this.currentWorkPos = null;
        this.clearCurrentArrivalMap(pathFinding);
    }

    protected void clearCurrentArrivalMap(MaidPathFindingBFS pathFinding) {
        pathFinding.finish();
    }

    protected MaidPathFindingBFS getOrCreateArrivalMap(ServerLevel worldIn, EntityMaid maid) {
        return new MaidPathFindingBFS(maid.m_21573_().m_26575_(), worldIn, maid);
    }

    private BlockPos getWorkSearchPos(EntityMaid maid) {
        if (maid.m_21536_()) {
            if (this.currentWorkPos != null && maid.m_21444_(this.currentWorkPos)) {
                return this.currentWorkPos;
            }
            return maid.m_21534_();
        }
        return maid.m_20183_();
    }

    private boolean checkOwnerPos(EntityMaid maid, BlockPos mutableBlockPos) {
        if (maid.isHomeModeEnable()) {
            return true;
        }
        return maid.m_269323_() != null && mutableBlockPos.m_203195_((Position)maid.m_269323_().m_20182_(), 8.0);
    }

    protected abstract boolean shouldMoveTo(ServerLevel var1, EntityMaid var2, BlockPos var3);

    @Deprecated(forRemoval=true)
    protected boolean checkPathReach(EntityMaid maid, BlockPos pos) {
        return maid.canPathReach(pos);
    }

    protected boolean checkPathReach(EntityMaid maid, MaidPathFindingBFS pathFinding, BlockPos pos) {
        return pathFinding.canPathReach(pos);
    }
}

