/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.goal;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.crafting.Ingredient;

public class MaidTemptGoal
extends Goal {
    private static final TargetingConditions TEMP_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
    protected final PathfinderMob mob;
    private final TargetingConditions targetingConditions;
    private final double speedModifier;
    private final Ingredient items;
    private final boolean canScare;
    @Nullable
    protected EntityMaid maid;
    private double px;
    private double py;
    private double pz;
    private int calmDown;
    private boolean isRunning;

    public MaidTemptGoal(PathfinderMob mob, double speedModifier, Ingredient items, boolean canScare) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.items = items;
        this.canScare = canScare;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.targetingConditions = TEMP_TARGETING.m_148354_().m_26888_(this::shouldFollow);
    }

    public boolean m_8036_() {
        if (this.calmDown > 0) {
            --this.calmDown;
            return false;
        }
        this.maid = (EntityMaid)this.mob.m_9236_().m_45963_(EntityMaid.class, this.targetingConditions, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), this.mob.m_20191_().m_82400_(10.0));
        return this.maid != null;
    }

    private boolean shouldFollow(LivingEntity livingEntity) {
        return this.items.test(livingEntity.m_21205_()) || this.items.test(livingEntity.m_21206_());
    }

    public boolean m_8045_() {
        if (this.canScare()) {
            if (this.mob.m_20280_((Entity)this.maid) < 36.0) {
                if (this.maid.m_20275_(this.px, this.py, this.pz) > 0.01) {
                    return false;
                }
            } else {
                this.px = this.maid.m_20185_();
                this.py = this.maid.m_20186_();
                this.pz = this.maid.m_20189_();
            }
        }
        return this.m_8036_();
    }

    protected boolean canScare() {
        return this.canScare;
    }

    public void m_8056_() {
        this.px = this.maid.m_20185_();
        this.py = this.maid.m_20186_();
        this.pz = this.maid.m_20189_();
        this.isRunning = true;
    }

    public void m_8041_() {
        this.maid = null;
        this.mob.m_21573_().m_26573_();
        this.calmDown = MaidTemptGoal.m_186073_((int)100);
        this.isRunning = false;
    }

    public void m_8037_() {
        this.mob.m_21563_().m_24960_((Entity)this.maid, (float)(this.mob.m_8085_() + 20), (float)this.mob.m_8132_());
        if (this.mob.m_20280_((Entity)this.maid) < 6.25) {
            this.mob.m_21573_().m_26573_();
        } else {
            this.mob.m_21573_().m_5624_((Entity)this.maid, this.speedModifier);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

