/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDamageEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidHurtEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MaidLivingEntityEvent {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)livingEntity;
            MaidHurtEvent maidHurtEvent = new MaidHurtEvent(maid, event.getSource(), event.getAmount());
            float damageAmount = MinecraftForge.EVENT_BUS.post((Event)maidHurtEvent) ? 0.0f : maidHurtEvent.getAmount();
            event.setAmount(damageAmount);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)livingEntity;
            MaidDamageEvent maidDamageEvent = new MaidDamageEvent(maid, event.getSource(), event.getAmount());
            float damageAfterAbsorption = MinecraftForge.EVENT_BUS.post((Event)maidDamageEvent) ? 0.0f : maidDamageEvent.getAmount();
            event.setAmount(damageAfterAbsorption);
        }
    }
}

