/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity.TileEntityEntityPlaceholderRenderer;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ItemEntityPlaceholder
extends Item {
    private static final String RECIPES_ID_TAG = "RecipeId";

    public ItemEntityPlaceholder() {
        super(new Item.Properties().m_41487_(1));
    }

    public static ItemStack setRecipeId(ItemStack stack, ResourceLocation id) {
        stack.m_41784_().m_128359_(RECIPES_ID_TAG, id.toString());
        return stack;
    }

    @Nullable
    public static ResourceLocation getRecipeId(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()).m_128425_(RECIPES_ID_TAG, 8)) {
            return new ResourceLocation(tag.m_128461_(RECIPES_ID_TAG));
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fillItemCategory(CreativeModeTab.Output items) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        world.m_7465_().m_44013_(InitRecipes.ALTAR_CRAFTING).forEach(recipe -> {
            if (!recipe.isItemCraft()) {
                items.m_246342_(ItemEntityPlaceholder.setRecipeId(new ItemStack((ItemLike)InitItems.ENTITY_PLACEHOLDER.get()), recipe.m_6423_()));
            }
        });
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                Minecraft minecraft = Minecraft.m_91087_();
                return new TileEntityEntityPlaceholderRenderer(minecraft.m_167982_(), minecraft.m_167973_());
            }
        });
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43719_() == Direction.UP) {
            Recipe recipe;
            ResourceLocation id = ItemEntityPlaceholder.getRecipeId(context.m_43722_());
            Level world = context.m_43725_();
            if (id != null && world instanceof ServerLevel && (recipe = (Recipe)context.m_43725_().m_7465_().m_44054_(InitRecipes.ALTAR_CRAFTING).get(id)) instanceof AltarRecipe) {
                AltarRecipe altarRecipe = (AltarRecipe)recipe;
                altarRecipe.spawnOutputEntity((ServerLevel)world, context.m_8083_().m_7494_(), null);
                context.m_43722_().m_41774_(1);
            }
        }
        return super.m_6225_(context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_7626_(ItemStack stack) {
        ResourceLocation recipeId = ItemEntityPlaceholder.getRecipeId(stack);
        if (recipeId != null) {
            Path path = Paths.get(recipeId.m_135815_().toLowerCase(Locale.US), new String[0]);
            String namespace = recipeId.m_135827_().toLowerCase(Locale.US);
            String langKey = String.format("jei.%s.altar_craft.%s.result", namespace, path.getFileName());
            return Component.m_237115_((String)langKey);
        }
        return Component.m_237115_((String)"item.touhou_little_maid.entity_placeholder");
    }
}

