/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDamageEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticleMessage;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DrownProtectBauble
implements IMaidBauble {
    public DrownProtectBauble() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingDamage(MaidDamageEvent event) {
        int slot;
        EntityMaid maid = event.getMaid();
        DamageSource source = event.getSource();
        if (source.m_269533_(DamageTypeTags.f_268581_) && (slot = ItemsUtil.getBaubleSlotInMaid(maid, this)) >= 0) {
            event.setCanceled(true);
            ItemStack stack = maid.getMaidBauble().getStackInSlot(slot);
            stack.m_41622_(1, (LivingEntity)maid, m -> maid.sendItemBreakMessage(stack));
            maid.getMaidBauble().setStackInSlot(slot, stack);
            maid.m_20301_(maid.m_6062_());
            NetworkHandler.sendToNearby((Entity)maid, new SpawnParticleMessage(maid.m_19879_(), SpawnParticleMessage.Type.BUBBLE));
            LivingEntity livingEntity = maid.m_269323_();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                InitTrigger.MAID_EVENT.trigger(serverPlayer, "use_protect_bauble");
            }
        }
    }
}

