/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void positionRider(Entity passenger, Entity.MoveFunction callback, CallbackInfo ci) {
        EntityMaid maid;
        Entity entity;
        if (passenger instanceof EntityMaid && (entity = (maid = (EntityMaid)passenger).m_20202_()) instanceof Player) {
            Player player = (Player)entity;
            Vec3 position = player.m_20182_();
            float radians = (float)(-Math.toRadians(player.f_20883_));
            Vec3 offset = position.m_82549_(new Vec3(0.0, 0.0, 0.75).m_82524_(radians));
            double yOffset = 0.15;
            if (player.m_20164_()) {
                yOffset -= 0.3;
            }
            callback.m_20372_(passenger, offset.m_7096_(), offset.m_7098_() + yOffset, offset.m_7094_());
            ci.cancel();
        }
    }

    @Inject(method={"collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")})
    private void onCollide(Vec3 pVec, CallbackInfoReturnable<Vec3> cir) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof EntityBroom) {
            EntityBroom broom = (EntityBroom)((Object)entityMixin);
            broom.inPhysicalCheck = true;
        }
    }

    @Inject(method={"collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")})
    private void onCollideReturn(Vec3 pVec, CallbackInfoReturnable<Vec3> cir) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof EntityBroom) {
            EntityBroom broom = (EntityBroom)((Object)entityMixin);
            broom.inPhysicalCheck = false;
        }
    }

    @Inject(method={"getBoundingBox"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetBoundingBox(CallbackInfoReturnable<AABB> cir) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof EntityBroom) {
            EntityBroom broom = (EntityBroom)((Object)entityMixin);
            if (broom.inPhysicalCheck) {
                cir.setReturnValue((Object)broom.getPhysicalBoundingBox());
            }
        }
    }
}

