/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SchedulePos;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.CheckSchedulePosMessage;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MaidConfigMessage {
    private final int id;
    private final boolean home;
    private final boolean pick;
    private final boolean ride;
    private final MaidSchedule schedule;

    public MaidConfigMessage(int id, boolean home, boolean pick, boolean ride, MaidSchedule schedule) {
        this.id = id;
        this.home = home;
        this.pick = pick;
        this.ride = ride;
        this.schedule = schedule;
    }

    public static void encode(MaidConfigMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.id);
        buf.writeBoolean(message.home);
        buf.writeBoolean(message.pick);
        buf.writeBoolean(message.ride);
        buf.m_130068_((Enum)message.schedule);
    }

    public static MaidConfigMessage decode(FriendlyByteBuf buf) {
        return new MaidConfigMessage(buf.readInt(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), (MaidSchedule)buf.m_130066_(MaidSchedule.class));
    }

    public static void handle(MaidConfigMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.id);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender)) {
                    if (maid.isHomeModeEnable() != message.home) {
                        MaidConfigMessage.handleHome(message, sender, maid);
                    }
                    if (maid.isPickup() != message.pick) {
                        maid.setPickup(message.pick);
                    }
                    if (maid.isRideable() != message.ride) {
                        maid.setRideable(message.ride);
                        Entity vehicle = maid.m_20202_();
                        if (!message.ride && vehicle != null && !MaidConfigMessage.isStopRideBlocklist(vehicle)) {
                            maid.m_8127_();
                        }
                    }
                    if (maid.getSchedule() != message.schedule) {
                        LivingEntity patt3817$temp;
                        maid.setSchedule(message.schedule);
                        maid.getSchedulePos().restrictTo(maid);
                        if (maid.isHomeModeEnable()) {
                            BehaviorUtils.m_22617_((LivingEntity)maid, (BlockPos)maid.m_21534_(), (float)0.7f, (int)3);
                        }
                        if ((patt3817$temp = maid.m_269323_()) instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)patt3817$temp;
                            InitTrigger.MAID_EVENT.trigger(serverPlayer, "switch_schedule");
                        }
                    }
                }
            });
        }
        context.setPacketHandled(true);
    }

    private static boolean isStopRideBlocklist(Entity vehicle) {
        EntityBroom broom;
        boolean isSit = vehicle instanceof EntitySit;
        boolean isBroom = vehicle instanceof EntityBroom && !(broom = (EntityBroom)vehicle).m_20096_();
        return isSit || isBroom;
    }

    private static void handleHome(MaidConfigMessage message, ServerPlayer sender, EntityMaid maid) {
        if (message.home) {
            SchedulePos schedulePos = maid.getSchedulePos();
            if (schedulePos.isConfigured()) {
                ResourceLocation dimension = schedulePos.getDimension();
                if (!dimension.equals((Object)maid.f_19853_.m_46472_().m_135782_())) {
                    CheckSchedulePosMessage tips = new CheckSchedulePosMessage((Component)Component.m_237115_((String)"message.touhou_little_maid.check_schedule_pos.dimension"));
                    NetworkHandler.sendToClientPlayer(tips, (Player)sender);
                    return;
                }
                BlockPos nearestPos = schedulePos.getNearestPos(maid);
                if (nearestPos != null && nearestPos.m_123331_((Vec3i)maid.m_20183_()) > 1024.0) {
                    CheckSchedulePosMessage tips = new CheckSchedulePosMessage((Component)Component.m_237115_((String)"message.touhou_little_maid.check_schedule_pos.too_far"));
                    NetworkHandler.sendToClientPlayer(tips, (Player)sender);
                    return;
                }
            }
            schedulePos.setHomeModeEnable(maid, maid.m_20183_());
        } else {
            maid.m_21446_(BlockPos.f_121853_, (Integer)MaidConfig.MAID_NON_HOME_RANGE.get());
        }
        maid.setHomeModeEnable(message.home);
    }
}

