/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.ItemServantBell;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServantBellSetMessage {
    private final int id;
    private final String tip;

    public ServantBellSetMessage(int id, String tip) {
        this.id = id;
        this.tip = tip;
    }

    public static void encode(ServantBellSetMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.id);
        buf.m_130070_(message.tip);
    }

    public static ServantBellSetMessage decode(FriendlyByteBuf buf) {
        return new ServantBellSetMessage(buf.readInt(), buf.m_130277_());
    }

    public static void handle(ServantBellSetMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Entity entity = sender.f_19853_.m_6815_(message.id);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).m_21830_((LivingEntity)sender)) {
                    ItemStack mainHandItem = sender.m_21205_();
                    ItemServantBell.recordMaidInfo(mainHandItem, maid.m_20148_(), message.tip);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

