/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.item.ItemFoxScroll;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SetScrollData {
    private final String dimension;
    private final BlockPos pos;

    public SetScrollData(String dimension, BlockPos pos) {
        this.dimension = dimension;
        this.pos = pos;
    }

    public static void encode(SetScrollData message, FriendlyByteBuf buf) {
        buf.m_130070_(message.dimension);
        buf.m_130064_(message.pos);
    }

    public static SetScrollData decode(FriendlyByteBuf buf) {
        return new SetScrollData(buf.m_130277_(), buf.m_130135_());
    }

    public static void handle(SetScrollData message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                ItemStack item = sender.m_21205_();
                if (item.m_41720_() instanceof ItemFoxScroll) {
                    ItemFoxScroll.setTrackInfo(item, message.dimension, message.pos);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

