/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TileEntityMaidBeacon
extends BlockEntity {
    public static final String POTION_INDEX_TAG = "PotionIndex";
    public static final BlockEntityType<TileEntityMaidBeacon> TYPE = BlockEntityType.Builder.m_155273_(TileEntityMaidBeacon::new, (Block[])new Block[]{(Block)InitBlocks.MAID_BEACON.get()}).m_58966_(null);
    public static final String STORAGE_POWER_TAG = "StoragePower";
    public static final String OVERFLOW_DELETE_TAG = "OverflowDelete";
    private int potionIndex = -1;
    private float storagePower;
    private boolean overflowDelete = false;

    public TileEntityMaidBeacon(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TileEntityMaidBeacon beacon) {
        if (beacon.f_58857_ != null && !level.f_46443_ && level.m_46467_() % 80L == 0L) {
            if (beacon.potionIndex != -1 && beacon.storagePower >= beacon.getEffectCost()) {
                beacon.storagePower -= beacon.getEffectCost();
                beacon.updateBeaconEffect(level, BeaconEffect.getEffectByIndex(beacon.potionIndex).getEffect());
            }
            beacon.updateAbsorbPower(level);
        }
    }

    private void updateBeaconEffect(Level world, MobEffect potion) {
        List list = world.m_6443_(EntityMaid.class, new AABB(this.m_58899_()).m_82377_(8.0, 8.0, 8.0), LivingEntity::m_6084_);
        for (EntityMaid maid : list) {
            maid.m_7292_(new MobEffectInstance(potion, 100, 1, true, true));
        }
    }

    private void updateAbsorbPower(Level world) {
        int range = (Integer)MiscConfig.SHRINE_LAMP_MAX_RANGE.get();
        List list = world.m_6443_(EntityPowerPoint.class, new AABB(this.m_58899_()).m_82377_((double)range, (double)range, (double)range), Entity::m_6084_);
        for (EntityPowerPoint powerPoint : list) {
            float addNum = this.getStoragePower() + (float)powerPoint.value / 100.0f;
            if (addNum <= this.getMaxStorage()) {
                this.setStoragePower(addNum);
                powerPoint.spawnExplosionParticle();
                powerPoint.m_146870_();
                continue;
            }
            if (!this.overflowDelete) continue;
            powerPoint.spawnExplosionParticle();
            powerPoint.m_146870_();
        }
    }

    public void m_183515_(CompoundTag compound) {
        this.getPersistentData().m_128405_(POTION_INDEX_TAG, this.potionIndex);
        this.getPersistentData().m_128350_(STORAGE_POWER_TAG, this.storagePower);
        this.getPersistentData().m_128379_(OVERFLOW_DELETE_TAG, this.overflowDelete);
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.potionIndex = this.getPersistentData().m_128451_(POTION_INDEX_TAG);
        this.storagePower = this.getPersistentData().m_128457_(STORAGE_POWER_TAG);
        this.overflowDelete = this.getPersistentData().m_128471_(OVERFLOW_DELETE_TAG);
    }

    public void loadData(CompoundTag data) {
        this.potionIndex = data.m_128451_(POTION_INDEX_TAG);
        this.storagePower = data.m_128457_(STORAGE_POWER_TAG);
        this.overflowDelete = data.m_128471_(OVERFLOW_DELETE_TAG);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public int getPotionIndex() {
        return this.potionIndex;
    }

    public void setPotionIndex(int potionIndex) {
        this.potionIndex = potionIndex;
        this.refresh();
    }

    public float getStoragePower() {
        return this.storagePower;
    }

    public void setStoragePower(float storagePower) {
        this.storagePower = storagePower;
        this.refresh();
    }

    public boolean isOverflowDelete() {
        return this.overflowDelete;
    }

    public void setOverflowDelete(boolean overflowDelete) {
        this.overflowDelete = overflowDelete;
        this.refresh();
    }

    public float getEffectCost() {
        return (float)((Double)MiscConfig.SHRINE_LAMP_EFFECT_COST.get() / 900.0);
    }

    public float getMaxStorage() {
        return ((Double)MiscConfig.SHRINE_LAMP_MAX_STORAGE.get()).floatValue();
    }

    public void refresh() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public static enum BeaconEffect {
        SPEED(MobEffects.f_19596_),
        FIRE_RESISTANCE(MobEffects.f_19607_),
        STRENGTH(MobEffects.f_19600_),
        RESISTANCE(MobEffects.f_19606_),
        REGENERATION(MobEffects.f_19605_);

        private final MobEffect effect;

        private BeaconEffect(MobEffect effect) {
            this.effect = effect;
        }

        public static BeaconEffect getEffectByIndex(int index) {
            return BeaconEffect.values()[Mth.m_14045_((int)0, (int)index, (int)(BeaconEffect.values().length - 1))];
        }

        public MobEffect getEffect() {
            return this.effect;
        }
    }
}

