/*
 * Decompiled with CFR 0.152.
 */
package weather2.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import weather2.WeatherBlocks;
import weather2.config.ConfigWind;
import weather2.energy.EnergyManager;
import weather2.util.WeatherUtilEntity;
import weather2.util.WindReader;
import weather2.weathersystem.WeatherManager;

public class WindTurbineBlockEntity
extends BlockEntity {
    public float smoothAngle = 0.0f;
    public float smoothAnglePrev = 0.0f;
    public float smoothAngleRotationalVel = 0.0f;
    public boolean isOutsideCached = false;
    private boolean needsInit = true;
    private LazyOptional<EnergyManager> energy;
    private EnergyManager energyManager;
    private int maxNormalGenerated = ConfigWind.Wind_Turbine_FE_Generated_Per_Tick;
    private int capacity;
    private int maxTransfer = this.capacity = this.maxNormalGenerated * 2;
    private float lastWindSpeed = 0.0f;

    public WindTurbineBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)WeatherBlocks.BLOCK_ENTITY_WIND_TURBINE.get(), p_155229_, p_155230_);
        this.energyManager = new EnergyManager(this.maxTransfer, this.capacity);
        this.energy = LazyOptional.of(() -> this.energyManager);
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WindTurbineBlockEntity entity) {
        entity.tick(level, pos, state);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        WeatherManager weatherManager;
        if (this.needsInit) {
            this.needsInit = false;
            this.updateIsOutside();
        }
        if (level.m_46467_() % 100L == 0L) {
            this.updateIsOutside();
        }
        if (this.isOutsideCached && level.m_46467_() % 20L == 0L && (weatherManager = WindReader.getWeatherManagerFor(level)) != null) {
            this.lastWindSpeed = weatherManager.getWindManager().getWindSpeedPositional(this.m_58899_(), 2.0f, false);
        }
        if (!level.f_46443_) {
            if (this.isOutsideCached) {
                this.energyManager.addEnergy((int)((float)this.maxNormalGenerated * this.lastWindSpeed));
                this.outputEnergy();
            }
        } else {
            if (this.isOutsideCached) {
                float windSpeed = this.lastWindSpeed;
                float rotMax = 100.0f;
                float maxSpeed = windSpeed / 2.0f * rotMax;
                if (this.smoothAngleRotationalVel < maxSpeed) {
                    this.smoothAngleRotationalVel += windSpeed * 0.3f;
                }
                if (this.smoothAngleRotationalVel > rotMax) {
                    this.smoothAngleRotationalVel = rotMax;
                }
                if (this.smoothAngle >= 180.0f) {
                    this.smoothAngle -= 360.0f;
                }
            }
            this.smoothAnglePrev = this.smoothAngle;
            this.smoothAngle += this.smoothAngleRotationalVel;
            this.smoothAngleRotationalVel -= 0.01f;
            this.smoothAngleRotationalVel *= 0.99f;
            if (this.smoothAngleRotationalVel <= 0.0f) {
                this.smoothAngleRotationalVel = 0.0f;
            }
        }
    }

    public void updateIsOutside() {
        this.isOutsideCached = WeatherUtilEntity.isPosOutside(this.f_58857_, new Vec3((double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.5f), (double)((float)this.m_58899_().m_123343_() + 0.5f)), false, true);
    }

    public void outputEnergy() {
        if (this.energyManager.getEnergyStored() >= this.energyManager.getMaxExtract() && this.energyManager.canExtract()) {
            for (Direction direction : Direction.values()) {
                BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
                if (be == null) continue;
                be.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_()).ifPresent(storage -> {
                    if (be != this && storage.getEnergyStored() < storage.getMaxEnergyStored()) {
                        this.energyManager.drainEnergy(this.energyManager.getMaxExtract());
                        int n = storage.receiveEnergy(this.energyManager.getMaxExtract(), false);
                    }
                });
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        LazyOptional<T> energyCapability = this.energyManager.getCapability(cap);
        if (energyCapability.isPresent()) {
            return energyCapability;
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energy.invalidate();
    }
}

