/*
 * Decompiled with CFR 0.152.
 */
package weather2.client.tile;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Vector3f;
import weather2.ClientTickHandler;
import weather2.WeatherBlocks;
import weather2.blockentity.WindVaneBlockEntity;
import weather2.client.entity.model.WindVaneModel;
import weather2.weathersystem.WeatherManagerClient;
import weather2.weathersystem.wind.WindManager;

public class WindVaneEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static Map<String, ResourceLocation> resLocMap = Maps.newHashMap();
    private static Map<String, Material> materialMap = Maps.newHashMap();
    private final Block block = (Block)WeatherBlocks.BLOCK_WIND_VANE.get();
    protected final WindVaneModel model = new WindVaneModel(Minecraft.m_91087_().m_167973_().m_171103_(WindVaneModel.LAYER_LOCATION));

    public static Material getTEMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> WindVaneEntityRenderer.createTEMaterial(path));
    }

    private static Material createTEMaterial(String path) {
        return new Material(TextureAtlas.f_118259_, WindVaneEntityRenderer.getTextureTE(path));
    }

    public static ResourceLocation getTextureTE(String path) {
        return WindVaneEntityRenderer.getTexture(String.format("textures/blocks/te/%s.png", path));
    }

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> WindVaneEntityRenderer.getResLoc(path));
    }

    private static ResourceLocation getResLoc(String path) {
        return new ResourceLocation("weather2", path);
    }

    public static void renderModel(Material material, Model model, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        model.m_7695_(stack, buffer.m_6299_(model.m_103119_(material.m_119203_())), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public WindVaneEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void m_6922_(T te, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        this.model.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        ModelPart root = this.model.m_142109_();
        root.f_104200_ += 8.0f;
        root.f_104201_ += 8.0f;
        root.f_104202_ += 8.0f;
        root.f_104203_ = (float)((double)root.f_104203_ + Math.toRadians(180.0));
        root.f_104204_ = (float)((double)root.f_104204_ + Math.toRadians(180.0));
        root.f_104201_ += 28.0f;
        float scale = 0.5f;
        root.m_253072_(new Vector3f(scale, scale, scale));
        ModelPart top = this.model.m_142109_().m_171324_("root").m_171324_("base").m_171324_("middle").m_171324_("top");
        if (top != null) {
            boolean shaking;
            float lerpAngle;
            WeatherManagerClient weatherMan = ClientTickHandler.weatherManager;
            if (weatherMan == null) {
                return;
            }
            WindManager windMan = weatherMan.getWindManager();
            if (windMan == null) {
                return;
            }
            float renderAngle = lerpAngle = (float)Mth.m_14139_((double)partialTicks, (double)((WindVaneBlockEntity)((Object)te)).smoothAnglePrev, (double)((WindVaneBlockEntity)((Object)te)).smoothAngle);
            top.f_104204_ = (float)Math.toRadians(renderAngle);
            boolean bl = shaking = (double)windMan.getWindSpeed(te.m_58899_()) >= 1.5;
            if (shaking) {
                Random rand = new Random(te.m_58904_().m_46467_());
                top.f_104204_ += (float)((double)(rand.nextFloat() - rand.nextFloat()) * Math.toRadians(2.0));
                top.f_104205_ = (float)((double)(rand.nextFloat() - rand.nextFloat()) * Math.toRadians(1.0));
            }
        }
        WindVaneEntityRenderer.renderModel(WindVaneEntityRenderer.getTEMaterial("wind_vane"), (Model)this.model, stack, buffer, combinedLightIn, combinedOverlayIn);
    }
}

