/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.items;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.client.Tooltip;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.mods.adhooks.AdHooks;
import com.endertech.minecraft.mods.adhooks.client.ControlBindings;
import com.endertech.minecraft.mods.adhooks.parts.HookShot;
import com.endertech.minecraft.mods.adhooks.parts.Launcher;
import com.endertech.minecraft.mods.adhooks.properties.HookType;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LauncherItem
extends DamageableItem {
    public final HookType hookType;

    public LauncherItem(HookType hookType, DamageableItem.Properties<?> props) {
        super(null, props);
        this.hookType = hookType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag flag) {
        Options gs = GameKeys.getGameSettings();
        Tooltip tip = Tooltip.of((AbstractForgeMod)AdHooks.getInstance(), (String)"launcher", lines);
        ChatFormatting formText = ChatFormatting.RESET;
        if (Screen.m_96638_()) {
            tip.add(ChatFormatting.RED, "hook_strength", (Object)Float.valueOf(this.hookType.hook.getStrength()));
            tip.add(ChatFormatting.AQUA, "rope_elasticity", (Object)Float.valueOf(this.hookType.rope.getElasticity()));
            tip.add(ChatFormatting.YELLOW, "rope_max_length", (Object)this.hookType.rope.getMaxLength());
            tip.add(ChatFormatting.GREEN, "reeling_speed", (Object)Float.valueOf(this.hookType.launcher.getReelingSpeed()));
            tip.add(ChatFormatting.DARK_PURPLE, "jump_boost_strength", (Object)Float.valueOf(this.hookType.launcher.getJumpBoostStrength()));
            tip.add(ChatFormatting.GOLD, "tarzan_jump_strength", (Object)Float.valueOf(this.hookType.launcher.getTarzanJumpStrength()));
        } else if (Screen.m_96637_()) {
            for (InteractionHand hand : InteractionHand.values()) {
                String textUnhooking = ControlBindings.getTextFor(hand, HookShot.SynchedBools.UNHOOKING);
                String textLoosening = ControlBindings.getTextFor(hand, HookShot.SynchedBools.LOOSENING);
                String handName = hand.name().toLowerCase(Locale.ROOT);
                tip.add(handName, new Object[]{ChatFormatting.UNDERLINE});
                String textLaunching = ControlBindings.getTextFor(hand, HookShot.SynchedBools.LAUNCHING);
                tip.add("launch", new Object[]{ChatFormatting.RED, formText, textLaunching});
                String textPulling = ControlBindings.getTextFor(hand, HookShot.SynchedBools.PULLING);
                if (ControlBindings.areSameForBothHands(HookShot.SynchedBools.UNHOOKING)) {
                    tip.add("reel_unhook_same", new Object[]{ChatFormatting.GREEN, formText, textPulling, textUnhooking});
                } else {
                    tip.add("reel_unhook", new Object[]{ChatFormatting.GREEN, formText, textUnhooking});
                }
                tip.add("pull", new Object[]{ChatFormatting.YELLOW, formText, textPulling});
                if (ControlBindings.areSameForBothHands(HookShot.SynchedBools.LOOSENING)) {
                    tip.add("loosen_same", new Object[]{ChatFormatting.AQUA, formText, textPulling, textLoosening});
                } else {
                    tip.add("loosen", new Object[]{ChatFormatting.AQUA, formText, textLoosening});
                }
                tip.add("jump_boost", new Object[]{ChatFormatting.DARK_PURPLE, formText, textUnhooking, ControlBindings.getTextFor(hand, HookShot.SynchedBools.JUMPING)});
                tip.add("tarzan_jump", new Object[]{ChatFormatting.GOLD, formText, ControlBindings.getTextFor(hand, HookShot.SynchedBools.JUMPING)});
            }
            tip.add("other", new Object[]{ChatFormatting.UNDERLINE});
            tip.add("swing", new Object[]{ChatFormatting.BLUE, formText, Args.joinDelim((String)"-", (Object[])new Object[]{gs.f_92086_.m_90863_().getString(), gs.f_92088_.m_90863_().getString(), gs.f_92087_.m_90863_().getString(), gs.f_92085_.m_90863_().getString()})});
            tip.add("release", new Object[]{ChatFormatting.LIGHT_PURPLE, formText, gs.f_92096_.m_90863_().getString(), gs.f_92090_.m_90863_().getString()});
            tip.add("repair", new Object[]{ChatFormatting.DARK_GRAY, formText});
        } else {
            tip.add("more_info", new Object[]{ChatFormatting.GRAY, ChatFormatting.DARK_PURPLE});
            tip.add("controls", new Object[]{ChatFormatting.GRAY, ChatFormatting.DARK_PURPLE});
        }
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        stack.m_41784_();
    }

    public boolean onDroppedByPlayer(ItemStack stack, Player player) {
        return true;
    }

    public boolean onLeftClickEntity(ItemStack launcher, Player player, Entity entity) {
        return this.hookType != HookType.PUDGE;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND || !Launcher.stackHasLauncher(player.m_21206_())) {
            player.m_6672_(hand);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int inventorySlot, boolean isCurrentItem) {
        if (level.f_46443_ && entity instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)entity;
            Optional<InteractionHand> activeHand = Optional.empty();
            for (InteractionHand hand2 : InteractionHand.values()) {
                if (stack != player.m_21120_(hand2)) continue;
                activeHand = Optional.of(hand2);
            }
            activeHand.ifPresent(hand -> this.hookType.launcher.processPressedKeysBy(player, (InteractionHand)hand));
        }
    }
}

