/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.parts;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.data.BaseProperties;
import com.endertech.minecraft.forge.properties.synched.IHaveSynchedProperties;
import com.endertech.minecraft.forge.properties.synched.SynchedDoubleProperty;
import com.endertech.minecraft.forge.properties.synched.SynchedEnumProperty;
import com.endertech.minecraft.forge.properties.synched.SynchedIntProperty;
import com.endertech.minecraft.forge.properties.synched.SynchedProperties;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class Rope
implements IHaveSynchedProperties {
    public static final IntBounds LENGTH_BOUNDS = new IntBounds(Integer.valueOf(1), Integer.valueOf(80));
    public static final FloatBounds WIDTH_BOUNDS = new FloatBounds(Float.valueOf(1.0f), Float.valueOf(10.0f));
    public static final FloatBounds ELASTICITY_BOUNDS = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(0.95f));
    public static final FloatBounds BOUNCE_REDUCTION_BOUNDS = new FloatBounds(Float.valueOf(0.1f), Float.valueOf(0.3f));
    public final int segmentsAmount = 16;
    protected final SynchedIntProperty maxLength;
    protected final SynchedDoubleProperty width;
    protected final SynchedDoubleProperty elasticity;
    protected final SynchedEnumProperty<ChatFormatting> color;
    private final SynchedProperties synchedProperties = new SynchedProperties("Rope");

    public Rope(Properties<?> props) {
        this.maxLength = this.synchedProperty("maxLength", props.maxLength, LENGTH_BOUNDS, "Maximal rope length");
        this.width = this.synchedProperty("width", props.width, WIDTH_BOUNDS, "Rope width");
        this.elasticity = this.synchedProperty("elasticity", props.elasticity, ELASTICITY_BOUNDS, "Defines how elastic the rope is");
        this.color = this.synchedProperty("color", (Enum)props.color, ChatFormatting::m_126664_, "Rope color");
    }

    public int getMaxLength() {
        return (Integer)this.maxLength.getValue();
    }

    public float getWidth() {
        return ((Double)this.width.getValue()).floatValue();
    }

    public float getElasticity() {
        return ((Double)this.elasticity.getValue()).floatValue();
    }

    public ColorARGB getColor() {
        return Optional.ofNullable(((ChatFormatting)this.color.getValue()).m_126665_()).map(ColorARGB::from).orElse(ColorARGB.DEFAULT);
    }

    public float getBounceReduction() {
        return BOUNCE_REDUCTION_BOUNDS.interpolateDown(this.getElasticity()).floatValue();
    }

    public float getTensionForce(float ropeLength, float realDistance) {
        float diff = realDistance - ropeLength;
        float ropeStrength = this.getRopeStrength();
        return diff * ropeStrength;
    }

    public float getRopeStrength() {
        return CommonMath.Interpolation.down((float)this.getElasticity(), (FloatBounds)ELASTICITY_BOUNDS);
    }

    public float getMinLength(@Nullable LivingEntity shooter, @Nullable Entity target) {
        float shooterSize = shooter != null ? Math.max(shooter.m_20205_(), shooter.m_20206_()) : 0.0f;
        float targetSize = target != null ? Math.max(target.m_20205_(), target.m_20206_()) : 0.0f;
        float minLength = shooterSize + targetSize;
        minLength = (float)((double)minLength / 2.0);
        return minLength;
    }

    public FloatBounds getLengthBounds(@Nullable LivingEntity shooter, @Nullable Entity target) {
        float minLength = this.getMinLength(shooter, target);
        return FloatBounds.between((Float)Float.valueOf(minLength), (Float)Float.valueOf(this.getMaxLength()));
    }

    public SynchedProperties getSynchedProperties() {
        return this.synchedProperties;
    }

    public static class Properties<T extends Properties<T>>
    extends BaseProperties<T> {
        public int maxLength;
        public float width;
        public float elasticity;
        public ChatFormatting color = ChatFormatting.BLACK;

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public static Properties<?> of() {
            return new Properties<Properties>(Properties.class);
        }

        public T maxLength(int value) {
            this.maxLength = value;
            return (T)((Object)((Properties)this.self));
        }

        public T width(float value) {
            this.width = value;
            return (T)((Object)((Properties)this.self));
        }

        public T elasticity(float value) {
            this.elasticity = value;
            return (T)((Object)((Properties)this.self));
        }

        public T color(ChatFormatting color) {
            this.color = color;
            return (T)((Object)((Properties)this.self));
        }
    }
}

