/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adlods.Commands;
import com.endertech.minecraft.mods.adlods.deposit.Deposit;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenerator;
import com.endertech.minecraft.mods.adlods.init.BiomeModifierCodecs;
import com.endertech.minecraft.mods.adlods.init.Features;
import com.endertech.minecraft.mods.adlods.ore.FeatureDisabler;
import com.endertech.minecraft.mods.adlods.ore.Indicator;
import com.endertech.minecraft.mods.adlods.vanilla.VanillaController;
import com.endertech.minecraft.mods.adlods.world.ChunkStripper;
import com.mojang.brigadier.arguments.ArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod(value="adlods")
public class AdLods
extends AbstractForgeMod {
    public static final String ID = "adlods";
    private static AdLods instance;
    public final Features features;
    public final BiomeModifierCodecs codecs;

    public AdLods() {
        instance = this;
        this.features = new Features(this);
        this.codecs = new BiomeModifierCodecs(this);
        this.registerCommonConfig();
    }

    public static AdLods getInstance() {
        return instance;
    }

    public String getId() {
        return ID;
    }

    public AbstractForgeMod.RequiredSide getRequiredSide() {
        return AbstractForgeMod.RequiredSide.SERVER;
    }

    public void commonInit() {
    }

    public void commonConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
        value.push("Deposits");
        DepositGenerator.disabledDeposits = value.comment("Disables large deposits of a certain type").defineEnum("disabledDeposits", (Enum)DepositGenerator.DisabledDeposits.NONE);
        Deposit.globalSizeMultiplier = value.comment("Size multiplier to be applied to all deposits").defineInRange("globalSizeMultiplier", 1.0f, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(10.0f)));
        Deposit.globalSpawnRateMultiplier = value.comment("Spawn rate multiplier to be applied to all deposits").defineInRange("globalSpawnRateMultiplier", 1.0f, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(10.0f)));
        value.pop();
        value.push("Veins");
        VanillaController.disableLargeVeins = value.comment("Disables all large ore veins generated by the vanilla noise generator").define("disableVanillaLargeVeins", false);
        VanillaController.disabledVeins = value.worldRestart().comment("Disables small ore veins of a certain type").defineEnum("disabledVeins", (Enum)VanillaController.DisabledVeins.NONE);
        value.pop();
        value.push("Indicators");
        Indicator.enabled = value.comment("Enables/disables all above-ground indicators").define("enabled", true);
        Indicator.alwaysOnCeiling = value.comment("If enabled and the dimension has a ceiling (e.g. the Nether), the indicators will only spawn on the top surface of the ceiling").define("alwaysOnCeiling", false);
        value.pop();
        value.push("Features");
        FeatureDisabler.disabledFeaturesList = value.worldRestart().comment("Disables generation of the listed features in the world\nFormat: [\"modID:feature1\", \"modID:feature2\"]\nTo disable all generated features of the specified mod, use \"modID:*\"\nTo see available features, use the '/place feature' command\n").defineList("disabledFeatures", new String[0], str -> {
            try {
                if (UnitId.from((String)str).isEmpty()) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        });
        value.pop();
        value.push("Stripper");
        ChunkStripper.dressUnloadedChunks = value.comment("Automatically dress previously stripped chunks before unloading them to prevent data loss").define("dressUnloadedChunks", true);
        value.pop();
    }

    public void commonPostInit() {
        this.features.reload();
    }

    public void configUpdated(ModConfig config) {
        if (config.getType() == ModConfig.Type.COMMON) {
            this.features.reload();
        }
    }

    public void tagsUpdated() {
        this.features.reload();
    }

    protected void serverStopped(MinecraftServer server) {
        ((VanillaController)((Object)this.features.vanillaController.get())).unloadOres();
    }

    public void registerCommands(ServerCommand command, CommandBuildContext buildContext) {
        command.requires(ServerCommand.OpLevel.NORMAL);
        command.task("list_active_deposits").executes(Commands::listActiveDeposits, new ServerCommand.Arg[0]);
        command.task("list_active_geodes").executes(Commands::listActiveGeodes, new ServerCommand.Arg[0]);
        command.task("list_all_generated").executes(Commands::listAllGenerated, new ServerCommand.Arg[0]);
        command.task("list_generated_around").executes(Commands::listGeneratedAround, new ServerCommand.Arg[0]);
        command.task("open_deposit_config").executes(Commands::openDepositConfig, new ServerCommand.Arg[]{Commands.depositName()});
        command.task("open_geode_config").executes(Commands::openGeodeConfig, new ServerCommand.Arg[]{Commands.geodeName()});
        command.task("open_configs_folder").executes(Commands::openConfigsFolder, new ServerCommand.Arg[0]);
        command.task("open_latest_log").executes(Commands::openLatestLog, new ServerCommand.Arg[0]);
        command.task("define_deposit").executes(Commands::defineDeposit, new ServerCommand.Arg[]{Commands.depositName(), ServerCommand.Arg.of((String)"oreId", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)buildContext)), ServerCommand.Arg.integer((String)"rarity", (IntBounds)Deposit.Rarity.BOUNDS), ServerCommand.Arg.bounds((String)"size", (IntBounds)Deposit.Size.BOUNDS), ServerCommand.Arg.bounds((String)"altitude", (IntBounds)Deposit.Altitude.BOUNDS)});
        command.task("define_deposit_and_edit").executes(Commands::defineDepositAndEdit, new ServerCommand.Arg[]{Commands.depositName(), ServerCommand.Arg.of((String)"oreId", (ArgumentType)BlockStateArgument.m_234650_((CommandBuildContext)buildContext)), ServerCommand.Arg.integer((String)"rarity", (IntBounds)Deposit.Rarity.BOUNDS), ServerCommand.Arg.bounds((String)"size", (IntBounds)Deposit.Size.BOUNDS), ServerCommand.Arg.bounds((String)"altitude", (IntBounds)Deposit.Altitude.BOUNDS)});
        command.task("remove_deposit").executes(Commands::removeDeposit, new ServerCommand.Arg[]{Commands.depositName()});
        command.task("remove_geode").executes(Commands::removeGeode, new ServerCommand.Arg[]{Commands.geodeName()});
        command.task("spawn_deposit_here").executes(Commands::spawnDepositHere, new ServerCommand.Arg[]{Commands.depositName()});
        command.task("spawn_deposit_underground").executes(Commands::spawnDepositUnderground, new ServerCommand.Arg[]{Commands.depositName()});
        command.task("spawn_deposit_at_chunk").executes(Commands::spawnDepositAtChunk, new ServerCommand.Arg[]{Commands.depositName(), ServerCommand.Arg.integer((String)"chunkX", (IntBounds)IntBounds.INTEGER), ServerCommand.Arg.integer((String)"chunkZ", (IntBounds)IntBounds.INTEGER)});
        command.task("spawn_deposit_at_pos").executes(Commands::spawnDepositAtPos, new ServerCommand.Arg[]{Commands.depositName(), ServerCommand.Arg.of((String)"pos", (ArgumentType)BlockPosArgument.m_118239_())});
        command.task("spawn_geode_here").executes(Commands::spawnGeodeHere, new ServerCommand.Arg[]{Commands.geodeName()});
        command.task("spawn_geode_underground").executes(Commands::spawnGeodeUnderground, new ServerCommand.Arg[]{Commands.geodeName()});
        command.task("spawn_geode_at_chunk").executes(Commands::spawnGeodeAtChunk, new ServerCommand.Arg[]{Commands.geodeName(), ServerCommand.Arg.integer((String)"chunkX", (IntBounds)IntBounds.INTEGER), ServerCommand.Arg.integer((String)"chunkZ", (IntBounds)IntBounds.INTEGER)});
        command.task("spawn_geode_at_pos").executes(Commands::spawnGeodeAtPos, new ServerCommand.Arg[]{Commands.geodeName(), ServerCommand.Arg.of((String)"pos", (ArgumentType)BlockPosArgument.m_118239_())});
        command.task("test_deposit_here").executes(Commands::testDepositHere, new ServerCommand.Arg[]{Commands.depositName(), ServerCommand.Arg.integer((String)"size", (IntBounds)Deposit.Size.BOUNDS)});
        command.task("reload_configs").executes(Commands::reloadConfigs, new ServerCommand.Arg[0]);
        command.task("strip_chunk").executes(Commands::stripChunk, new ServerCommand.Arg[0]);
        command.task("strip_chunks_around").executes(Commands::stripChunksAround, new ServerCommand.Arg[0]);
        command.task("dress_chunk").executes(Commands::dressChunk, new ServerCommand.Arg[0]);
        command.task("dress_chunks_around").executes(Commands::dressChunksAround, new ServerCommand.Arg[0]);
        command.task("dress_all_chunks").executes(Commands::dressAllChunks, new ServerCommand.Arg[0]);
        command.register();
    }
}

