/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.ore;

import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.IReloadableData;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.AbstractGenerator;
import com.endertech.minecraft.mods.adlods.AdLods;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;

public class FeatureDisabler
extends AbstractGenerator
implements BiomeModifier,
IReloadableData {
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> disabledFeaturesList;
    protected final Set<String> disabledMods = new HashSet<String>();
    protected final Set<ResourceLocation> disabledFeatures = new HashSet<ResourceLocation>();

    public FeatureDisabler(AbstractForgeMod mod) {
        super(mod);
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.REMOVE && this.hasFeatures()) {
            for (GenerationStep.Decoration stage : GenerationStep.Decoration.values()) {
                List features = builder.getGenerationSettings().getFeatures(stage);
                features.removeIf(this::isFeatureDisabled);
            }
        }
    }

    protected boolean hasFeatures() {
        return !this.disabledMods.isEmpty() || !this.disabledFeatures.isEmpty();
    }

    protected boolean isFeatureDisabled(Holder<PlacedFeature> featureHolder) {
        ResourceLocation location = featureHolder.m_203543_().map(ResourceKey::m_135782_).orElseGet(() -> ForgeRegistries.FEATURES.getKey((Object)((ConfiguredFeature)((PlacedFeature)featureHolder.get()).f_191775_().get()).f_65377_()));
        if (location != null) {
            return this.disabledMods.contains(location.m_135827_()) || this.disabledFeatures.contains(location);
        }
        return false;
    }

    public void loadData() {
        this.disabledMods.clear();
        this.disabledFeatures.clear();
        for (String str : (List)disabledFeaturesList.get()) {
            UnitId id = UnitId.from((String)str);
            if (id.isEmpty()) continue;
            if (id.getMetaData().equals("*") && id.getModId().equals("minecraft")) {
                String modId = id.getRegName();
                if (!AbstractForgeMod.isLoaded((String)modId)) continue;
                this.disabledMods.add(modId);
                continue;
            }
            this.disabledFeatures.add(id.toResLoc());
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)AdLods.getInstance().codecs.featureDisabler.get();
    }

    public boolean generateAt(WorldGenLevel level, ChunkPos chunkPos, Random random) {
        return false;
    }
}

