/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.target;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.mods.adlods.deposit.Deposit;
import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.ore.Indicator;
import com.endertech.minecraft.mods.adlods.target.TargetGenResult;
import com.endertech.minecraft.mods.adlods.world.WorldTargets;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;

public abstract class AbstractTarget
extends AbstractOre {
    protected final boolean enabled;
    protected final String name;
    protected final int rarity;
    protected final Percentage chance;
    protected final Indicator indicator;

    public AbstractTarget(UnitConfig config, Properties<?> props) {
        super(config, props);
        String category = this.getClassCategory();
        this.name = props.name;
        this.enabled = UnitConfig.readConfigEnabled((UnitConfig)config, (boolean)props.enabled);
        this.rarity = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"rarity", (int)props.rarity, (IntBounds)Deposit.Rarity.BOUNDS, (String)"Rarity (in chunks). The higher the value, the rarer the generation will be.\nExample: a value of 1000 means that generation will occur approximately once every 1000 chunks.\n");
        this.chance = Percentage.value((float)Percentage.from((int)1, (int)this.rarity).getValue());
        this.indicator = new Indicator(config, category, props.indicators);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public Percentage getChance() {
        return this.chance;
    }

    public abstract int pickSizeToGenerate(WorldGenLevel var1, BlockPos var2, Random var3);

    public TargetGenResult generateAt(WorldGenLevel level, ChunkPos chunkPos, Random random) {
        ChunkBounds chunkBounds = ChunkBounds.from((LevelHeightAccessor)level, (ChunkPos)chunkPos);
        return this.generateAt(level, chunkBounds.getX().randomBetween(random), chunkBounds.getZ().randomBetween(random), random);
    }

    public TargetGenResult generateAt(WorldGenLevel level, int posX, int posZ, Random random) {
        BlockPos startPos = new BlockPos(posX, this.altitude.randomBetween(random).intValue(), posZ);
        int size = this.pickSizeToGenerate(level, startPos, random);
        return this.generateAt(level, startPos, size, false, random);
    }

    public TargetGenResult generateAt(WorldGenLevel level, BlockPos startPos, int size, boolean testing, Random random) {
        String target = this.getClass().getSimpleName();
        String name = this.getName();
        if (!testing && !this.inAllowedDimenstion((ServerLevelAccessor)level)) {
            ForgeEndertech.debugMsg((String)(target + ": " + name + " is not in allowable dimension"));
            return TargetGenResult.none(target, name, startPos);
        }
        int count = this.generate(level, startPos, size, testing, random);
        TargetGenResult result = new TargetGenResult(target, name, startPos, count, size - count, false);
        if (!testing && !result.isEmpty() && this.placeIndicator(level, result, false)) {
            result = result.withIndicator();
        }
        WorldTargets.get(level.m_6018_()).saveGenResult(result);
        ForgeEndertech.debugMsg((String)result.toString());
        return result;
    }

    @Override
    protected int generate(WorldGenLevel level, BlockPos startPos, int size, boolean testing, Random random) {
        return this.generate(level, startPos, startPos, size, testing, random, 0);
    }

    protected abstract int generate(WorldGenLevel var1, BlockPos var2, BlockPos var3, int var4, boolean var5, Random var6, int var7);

    public boolean placeIndicator(WorldGenLevel level, TargetGenResult result, boolean ignoreThreshold) {
        if (ignoreThreshold || result.completeness().isGreaterOrEqualTo((Object)this.indicator.threshold)) {
            return this.indicator.placeFor(level, result) > 0;
        }
        return false;
    }

    public static class Properties<T extends Properties<T>>
    extends AbstractOre.Properties<T> {
        public final String name;
        public boolean enabled = true;
        public int rarity = 0;
        public String[] indicators = new String[0];

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass);
            this.name = name;
        }

        public T dimensionByName() {
            if (this.name.startsWith("nether_") || this.name.endsWith("_nether")) {
                return (T)((Object)((Properties)((Object)this.dimension(Dimensions.THE_NETHER))));
            }
            if (this.name.startsWith("end_") || this.name.endsWith("_end")) {
                return (T)((Object)((Properties)((Object)this.dimension(Dimensions.THE_END))));
            }
            return (T)((Object)((Properties)((Object)this.dimension(Dimensions.OVERWORLD))));
        }

        public T disabled() {
            this.enabled = false;
            return (T)((Object)((Properties)this.self));
        }

        public T rarity(int rarity) {
            this.rarity = rarity;
            return (T)((Object)((Properties)this.self));
        }

        public T indicators(String ... indicators) {
            this.indicators = indicators;
            return (T)((Object)((Properties)this.self));
        }
    }
}

