/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.target;

import com.endertech.minecraft.mods.adlods.ore.AbstractOre;
import com.endertech.minecraft.mods.adlods.ore.Miscellaneous;
import com.endertech.minecraft.mods.adlods.ore.OreChain;
import com.endertech.minecraft.mods.adlods.target.AbstractTarget;
import com.endertech.minecraft.mods.adlods.world.WorldTargets;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;

public abstract class AbstractTargetOreChain<T extends AbstractTarget>
extends OreChain {
    protected final WorldGenLevel worldGenLevel;
    protected final T target;
    protected final BlockPos originPos;
    protected final ChunkPos originChunk;
    protected final ChunkPos startChunk;
    protected final boolean testing;
    protected int deferred = 0;

    protected AbstractTargetOreChain(WorldGenLevel level, T target, BlockPos originPos, BlockPos startPos, int maxLength, Miscellaneous miscellaneous, boolean testing, Random random) {
        super((LevelAccessor)level, startPos, maxLength, miscellaneous, random);
        this.worldGenLevel = level;
        this.target = target;
        this.originPos = originPos;
        this.originChunk = new ChunkPos(originPos);
        this.startChunk = new ChunkPos(startPos);
        this.testing = testing;
    }

    @Override
    protected boolean replaceWithOre(BlockPos pos) {
        return ((AbstractOre)this.target).replaceWithOre((LevelAccessor)this.worldGenLevel, pos, this.testing, this.random);
    }

    public void saveDeferredEntryPoint(BlockPos pos) {
        WorldTargets.get(this.worldGenLevel.m_6018_()).saveDeferredEntryPoint(pos, this.originPos);
    }

    public boolean inDeferredRegion(ChunkPos chunk) {
        return Math.abs(chunk.f_45578_ - this.startChunk.f_45578_) == 2 || Math.abs(chunk.f_45579_ - this.startChunk.f_45579_) == 2;
    }

    public boolean inFarRegion(ChunkPos chunk) {
        return Math.abs(chunk.f_45578_ - this.startChunk.f_45578_) > 2 || Math.abs(chunk.f_45579_ - this.startChunk.f_45579_) > 2;
    }

    public boolean inGenRegion(ChunkPos chunk) {
        return AbstractOre.withinGenRegion(chunk, this.startChunk);
    }

    public boolean inOriginGenRegion(ChunkPos chunk) {
        return AbstractOre.withinGenRegion(chunk, this.originChunk);
    }

    protected boolean inStartChunk(BlockPos pos) {
        return this.startChunk.equals((Object)new ChunkPos(pos));
    }

    public boolean inFullWorld() {
        return this.worldGenLevel instanceof ServerLevel;
    }

    public Optional<BlockPos> getEntryPoint(BlockPos pos) {
        if (this.lastUsedDirection == null || this.inFullWorld()) {
            return Optional.empty();
        }
        ChunkPos chunk = new ChunkPos(pos);
        BlockPos prevPos = pos.m_121945_(this.lastUsedDirection.m_122424_());
        ChunkPos prevChunk = new ChunkPos(prevPos);
        if (!chunk.equals((Object)prevChunk)) {
            if (this.inGenRegion(prevChunk) && this.inDeferredRegion(chunk)) {
                return Optional.of(pos);
            }
            if (this.inDeferredRegion(prevChunk) && this.inGenRegion(chunk)) {
                return Optional.of(prevPos);
            }
        }
        return Optional.empty();
    }

    protected boolean isValidBlock(BlockPos pos) {
        ChunkPos chunk = new ChunkPos(pos);
        if (this.inFullWorld() || this.inGenRegion(chunk)) {
            return ((AbstractOre)this.target).isValidPosition(this.worldGenLevel, pos, this.startPos, this.originPos, this.testing) && ((AbstractOre)this.target).canBeReplaced((LevelAccessor)this.worldGenLevel, pos, this.startPos, this.originPos, this.testing);
        }
        if (this.inDeferredRegion(chunk)) {
            return ((AbstractOre)this.target).withinHeightBounds(this.worldGenLevel, pos, this.startPos, this.originPos, this.testing);
        }
        if (this.testing && this.inFarRegion(chunk)) {
            return ((AbstractOre)this.target).withinHeightBounds(this.worldGenLevel, pos, this.startPos, this.originPos, this.testing);
        }
        return false;
    }

    @Override
    protected boolean isValidPath(BlockPos pos) {
        return super.isValidPath(pos) && (this.inFullWorld() || this.inGenRegion(new ChunkPos(pos)));
    }

    protected boolean isOutsideBounds(BlockPos pos) {
        return this.worldGenLevel.m_151570_(pos);
    }
}

