/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.target;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.math.Percentage;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;

public class TargetGenResult
implements INBTSerializable<TargetGenResult> {
    public static final TargetGenResult EMPTY = new TargetGenResult("", "", BlockPos.f_121853_, 0, 0, false);
    public final String target;
    public final String name;
    public final BlockPos pos;
    public final int size;
    public final int deferred;
    public final boolean indicator;

    public TargetGenResult(String target, String name, BlockPos pos, int size, int deferred, boolean indicator) {
        this.target = target;
        this.name = name;
        this.pos = pos;
        this.size = size;
        this.deferred = deferred;
        this.indicator = indicator;
    }

    public static TargetGenResult none(String target, String name, BlockPos pos) {
        return new TargetGenResult(target, name, pos, 0, 0, false);
    }

    public boolean isEmpty() {
        return this.size == 0 || this.name.isEmpty() || this.pos.equals((Object)BlockPos.f_121853_);
    }

    public boolean isComplete() {
        return this.deferred == 0;
    }

    public boolean hasIndicator() {
        return this.indicator;
    }

    public Percentage completeness() {
        return Percentage.from((int)this.size, (int)(this.size + this.deferred));
    }

    public TargetGenResult withIndicator() {
        return new TargetGenResult(this.target, this.name, this.pos, this.size, this.deferred, true);
    }

    public TargetGenResult readFrom(CompoundTag tag) {
        String target = tag.m_128461_("target");
        if (tag.m_128441_("DepositGenResult")) {
            tag = tag.m_128469_("DepositGenResult");
            target = "Deposit";
        }
        String name = tag.m_128461_("name");
        BlockPos pos = BlockPos.m_122022_((long)tag.m_128454_("pos"));
        int size = tag.m_128451_("size");
        int deferred = tag.m_128451_("deferred");
        boolean indicator = tag.m_128471_("indicator");
        return new TargetGenResult(target, name, pos, size, deferred, indicator);
    }

    public CompoundTag writeTo(CompoundTag tag) {
        tag.m_128359_("target", this.target);
        tag.m_128359_("name", this.name);
        tag.m_128356_("pos", this.pos.m_121878_());
        tag.m_128405_("size", this.size);
        tag.m_128405_("deferred", this.deferred);
        tag.m_128379_("indicator", this.indicator);
        return tag;
    }

    public String toString() {
        String chunk = "Chunk" + new ChunkPos(this.pos);
        return this.target + " " + Args.group((Object[])new Object[]{"name: " + this.name, "size=" + this.size, "complete: " + this.completeness(), "indicator: " + (this.hasIndicator() ? "yes" : "no"), this.pos, chunk});
    }
}

