/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.world;

import com.endertech.minecraft.mods.adlods.AdLods;
import com.endertech.minecraft.mods.adlods.world.ChunkStripper;
import com.endertech.minecraft.mods.adlods.world.WorldTargets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="adlods")
public class WorldEvents {
    @SubscribeEvent
    public static void onLevelLoaded(LevelEvent.Load event) {
        if (event.getLevel() instanceof ServerLevel) {
            AdLods.getInstance().features.reload();
        }
    }

    @SubscribeEvent
    public static void onLevelUnloaded(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            ChunkStripper.removeFor(level);
        }
    }

    @SubscribeEvent
    public static void onChunkDataLoading(ChunkDataEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            WorldTargets.get(level).removeDeferredEntryPointsIn(event.getChunk().m_7697_());
        }
    }

    @SubscribeEvent
    public static void onChunkLoading(ChunkEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            if (event.isNewChunk()) {
                WorldTargets.get(level).removeDeferredEntryPointsIn(event.getChunk().m_7697_());
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnloading(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            if (((Boolean)ChunkStripper.dressUnloadedChunks.get()).booleanValue()) {
                ChunkStripper.getFor((Level)level).dressChunk((Level)level, event.getChunk().m_7697_());
            }
        }
    }
}

