/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.entities;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridMultiblock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.orientation.BlockOrientation;
import appeng.api.stacks.AEKey;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.blockentity.crafting.CraftingCubeModelData;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.crafting.inv.ListCraftingInventory;
import appeng.me.cluster.IAEMultiBlock;
import appeng.util.NullConfigManager;
import appeng.util.Platform;
import appeng.util.iterators.ChainedIterator;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.pedroksl.advanced_ae.common.blocks.AAEAbstractCraftingUnitBlock;
import net.pedroksl.advanced_ae.common.blocks.AAECraftingUnitBlock;
import net.pedroksl.advanced_ae.common.blocks.AAECraftingUnitType;
import net.pedroksl.advanced_ae.common.cluster.AdvCraftingCPUCalculator;
import net.pedroksl.advanced_ae.common.cluster.AdvCraftingCPUCluster;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;

public class AdvCraftingBlockEntity
extends AENetworkBlockEntity
implements IAEMultiBlock<AdvCraftingCPUCluster>,
IPowerChannelState,
IConfigurableObject {
    private final AdvCraftingCPUCalculator calc = new AdvCraftingCPUCalculator(this);
    private CompoundTag previousState = null;
    private boolean isCoreBlock = false;
    private AdvCraftingCPUCluster cluster;

    public AdvCraftingBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.MULTIBLOCK, GridFlags.REQUIRE_CHANNEL}).addService(IGridMultiblock.class, (IGridNodeService)((IGridMultiblock)this::getMultiblockNodes));
    }

    protected Item getItemFromBlockEntity() {
        if (this.f_58857_ == null) {
            return Items.f_41852_;
        }
        return this.getUnitBlock().type.getItemFromType();
    }

    public void setName(String name) {
        super.setName(name);
        if (this.cluster != null) {
            this.cluster.updateName();
        }
    }

    public AAEAbstractCraftingUnitBlock<?> getUnitBlock() {
        if (this.f_58857_ == null || this.notLoaded() || this.m_58901_()) {
            return AAEBlocks.QUANTUM_UNIT.block();
        }
        Block block = this.f_58857_.m_8055_(this.f_58858_).m_60734_();
        return block instanceof AAEAbstractCraftingUnitBlock ? (AAEAbstractCraftingUnitBlock)block : (AAEAbstractCraftingUnitBlock)AAEBlocks.QUANTUM_UNIT.block();
    }

    public long getStorageBytes() {
        return this.getUnitBlock().type.getStorageBytes();
    }

    public int getStorageMultiplier() {
        return ((AAECraftingUnitType)this.getUnitBlock().type).getStorageMultiplier();
    }

    public int getAcceleratorThreads() {
        return this.getUnitBlock().type.getAcceleratorThreads();
    }

    public int getAccelerationMultiplier() {
        return ((AAECraftingUnitType)this.getUnitBlock().type).getAccelerationMultiplier();
    }

    public void onReady() {
        super.onReady();
        this.getMainNode().setVisualRepresentation((ItemLike)this.getItemFromBlockEntity());
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.calc.calculateMultiblock(serverLevel, this.f_58858_);
        }
    }

    public void updateMultiBlock(BlockPos changedPos) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.calc.updateMultiblockAfterNeighborUpdate(serverLevel, this.f_58858_, changedPos);
        }
    }

    public void updateStatus(AdvCraftingCPUCluster c) {
        if (this.cluster != null && this.cluster != c) {
            this.cluster.breakCluster();
        }
        this.cluster = c;
        this.updateSubType(true);
    }

    public void updateSubType(boolean updateFormed) {
        if (this.f_58857_ == null || this.notLoaded() || this.m_58901_()) {
            return;
        }
        boolean formed = this.isFormed();
        boolean power = this.getMainNode().isOnline();
        BlockState current = this.f_58857_.m_8055_(this.f_58858_);
        if (current.m_60734_() instanceof AAEAbstractCraftingUnitBlock) {
            int lightLevel = this.getUnitBlock().type == AAECraftingUnitType.QUANTUM_CORE ? 10 : (this.getUnitBlock().type == AAECraftingUnitType.STRUCTURE ? 5 : 0);
            lightLevel = formed && power ? lightLevel : 0;
            BlockState newState = (BlockState)((BlockState)((BlockState)current.m_61124_((Property)AAEAbstractCraftingUnitBlock.POWERED, (Comparable)Boolean.valueOf(power))).m_61124_((Property)AAEAbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(formed))).m_61124_((Property)AAECraftingUnitBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(lightLevel));
            if (current != newState) {
                this.f_58857_.m_7731_(this.f_58858_, newState, 2);
            }
        }
        if (updateFormed) {
            this.onGridConnectableSidesChanged();
        }
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        if (this.isFormed()) {
            return this.getUnitBlock().type == AAECraftingUnitType.QUANTUM_CORE ? EnumSet.of(Direction.UP, Direction.DOWN) : EnumSet.allOf(Direction.class);
        }
        return EnumSet.noneOf(Direction.class);
    }

    public boolean isFormed() {
        if (this.isClientSide()) {
            return (Boolean)this.m_58900_().m_61143_((Property)AAEAbstractCraftingUnitBlock.FORMED);
        }
        return this.cluster != null;
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        data.m_128379_("core", this.isCoreBlock());
        if (this.isCoreBlock() && this.cluster != null) {
            this.cluster.writeToNBT(data);
        }
    }

    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.setCoreBlock(data.m_128471_("core"));
        if (this.isCoreBlock()) {
            if (this.cluster != null) {
                this.cluster.readFromNBT(data);
            } else {
                this.setPreviousState(data.m_6426_());
            }
        }
    }

    public void disconnect(boolean update) {
        if (this.cluster != null) {
            this.cluster.destroy();
            if (update) {
                this.updateSubType(true);
            }
        }
    }

    public AdvCraftingCPUCluster getCluster() {
        return this.cluster;
    }

    public boolean isValid() {
        return true;
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason != IGridNodeListener.State.GRID_BOOT) {
            this.updateSubType(false);
        }
    }

    public void breakCluster() {
        if (this.cluster != null) {
            this.cluster.cancelJobs();
            List<ListCraftingInventory> inventories = this.cluster.getInventories();
            ArrayList<BlockPos> places = new ArrayList<BlockPos>();
            for (AdvCraftingBlockEntity blockEntity : this.cluster::getBlockEntities) {
                if (this == blockEntity) {
                    places.add(this.f_58858_);
                    continue;
                }
                for (Direction d : Direction.values()) {
                    BlockPos p = blockEntity.f_58858_.m_121945_(d);
                    if (!this.f_58857_.m_46859_(p)) continue;
                    places.add(p);
                }
            }
            if (places.isEmpty()) {
                throw new IllegalStateException(String.valueOf(this.cluster) + " does not contain any kind of blocks, which were destroyed.");
            }
            for (ListCraftingInventory inv : inventories) {
                for (Object2LongMap.Entry entry : inv.list) {
                    BlockPos position = (BlockPos)Util.m_214621_(places, (RandomSource)this.f_58857_.m_213780_());
                    ArrayList stacks = new ArrayList();
                    ((AEKey)entry.getKey()).addDrops(entry.getLongValue(), stacks, this.f_58857_, position);
                    Platform.spawnDrops((Level)this.f_58857_, (BlockPos)position, stacks);
                }
                inv.clear();
            }
            this.cluster.destroy();
        }
    }

    public boolean isPowered() {
        if (this.isClientSide()) {
            return (Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)AAEAbstractCraftingUnitBlock.POWERED);
        }
        return this.getMainNode().isActive();
    }

    public boolean isActive() {
        if (!this.isClientSide()) {
            return this.getMainNode().isActive();
        }
        return this.isPowered() && this.isFormed();
    }

    public boolean isCoreBlock() {
        return this.isCoreBlock;
    }

    public void setCoreBlock(boolean isCoreBlock) {
        this.isCoreBlock = isCoreBlock;
    }

    public CompoundTag getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(CompoundTag previousState) {
        this.previousState = previousState;
    }

    public ModelData getModelData() {
        return CraftingCubeModelData.create(this.getConnections());
    }

    protected EnumSet<Direction> getConnections() {
        if (this.f_58857_ == null) {
            return EnumSet.noneOf(Direction.class);
        }
        EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
        for (Direction facing : Direction.values()) {
            if (!this.isConnected((BlockGetter)this.f_58857_, this.f_58858_, facing)) continue;
            connections.add(facing);
        }
        return connections;
    }

    private boolean isConnected(BlockGetter level, BlockPos pos, Direction side) {
        BlockPos adjacentPos = pos.m_121945_(side);
        return level.m_8055_(adjacentPos).m_60734_() instanceof AAEAbstractCraftingUnitBlock;
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.requestModelDataUpdate();
    }

    private Iterator<IGridNode> getMultiblockNodes() {
        if (this.getCluster() == null) {
            return new ChainedIterator((Object[])new IGridNode[0]);
        }
        ArrayList<IGridNode> nodes = new ArrayList<IGridNode>();
        Iterator<AdvCraftingBlockEntity> it = this.getCluster().getBlockEntities();
        while (it.hasNext()) {
            IGridNode node = it.next().getGridNode();
            if (node == null) continue;
            nodes.add(node);
        }
        return nodes.iterator();
    }

    public IConfigManager getConfigManager() {
        AdvCraftingCPUCluster cluster = this.getCluster();
        if (cluster != null) {
            return this.getCluster().getConfigManager();
        }
        return NullConfigManager.INSTANCE;
    }
}

