/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public abstract class IngredientStack<T, P> {
    protected final T ingredient;
    protected int amount;

    IngredientStack(T ingredient, int amount) {
        this.ingredient = ingredient;
        this.amount = amount;
    }

    public static Item of(ItemStack stack) {
        return new Item(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), stack.m_41613_());
    }

    public static Item of(Ingredient ingredient, int amount) {
        return new Item(ingredient, amount);
    }

    public static Fluid of(FluidStack stack) {
        return new Fluid(stack.getFluid(), stack.getAmount());
    }

    public T getIngredient() {
        return this.ingredient;
    }

    public int getAmount() {
        return this.amount;
    }

    public void consume(P stack) {
        if (this.amount <= 0) {
            return;
        }
        if (this.test(stack)) {
            int from = this.getStackAmount(stack);
            if (from > this.amount) {
                this.setStackAmount(stack, from - this.amount);
                this.amount = 0;
            } else {
                this.setStackAmount(stack, 0);
                this.amount -= from;
            }
        }
    }

    public boolean isEmpty() {
        return this.amount <= 0;
    }

    public abstract boolean test(P var1);

    public abstract IngredientStack<T, P> sample();

    public abstract boolean checkType(Object var1);

    public abstract int getStackAmount(P var1);

    public abstract void setStackAmount(P var1, int var2);

    public abstract void toNetwork(FriendlyByteBuf var1);

    public abstract JsonElement toJson();

    public static final class Item
    extends IngredientStack<Ingredient, ItemStack> {
        public static final Codec<Item> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ExtraCodecs.f_252400_.fieldOf("item").forGetter(Item::toJson)).apply((Applicative)builder, Item::fromJson));

        public Item(Ingredient ingredient, int amount) {
            super(ingredient, amount);
        }

        @Override
        public boolean test(ItemStack stack) {
            return ((Ingredient)this.ingredient).test(stack);
        }

        public Item sample() {
            return new Item((Ingredient)this.ingredient, this.amount);
        }

        @Override
        public boolean checkType(Object obj) {
            return obj instanceof ItemStack;
        }

        @Override
        public int getStackAmount(ItemStack stack) {
            return stack.m_41613_();
        }

        @Override
        public void setStackAmount(ItemStack stack, int amount) {
            stack.m_41764_(amount);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            ((Ingredient)this.ingredient).m_43923_(buffer);
            buffer.writeInt(this.amount);
        }

        @Override
        public JsonElement toJson() {
            JsonObject json = new JsonObject();
            json.add("ingredient", ((Ingredient)this.ingredient).m_43942_());
            json.addProperty("amount", (Number)this.amount);
            return json;
        }

        public static Item fromNetwork(FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int amount = buffer.readInt();
            return new Item(ingredient, amount);
        }

        public static Item fromJson(@Nullable JsonElement json) {
            if (json != null && !json.isJsonNull()) {
                if (json.isJsonObject()) {
                    JsonObject jsonObj = json.getAsJsonObject();
                    Ingredient ingredient = Ingredient.m_288218_((JsonElement)jsonObj.get("ingredient"), (boolean)false);
                    int amount = jsonObj.get("amount").getAsInt();
                    return new Item(ingredient, amount);
                }
                throw new JsonSyntaxException("Expected item to be object");
            }
            throw new JsonSyntaxException("Item cannot be null");
        }
    }

    public static class Fluid
    extends IngredientStack<net.minecraft.world.level.material.Fluid, FluidStack> {
        public static final Codec<Fluid> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)FluidStack.CODEC.fieldOf("fluidStack").forGetter(Fluid::getStack)).apply((Applicative)builder, Fluid::new));

        public Fluid(FluidStack stack) {
            super(stack.getFluid(), stack.getAmount());
        }

        public Fluid(net.minecraft.world.level.material.Fluid fluid, int amount) {
            super(fluid, amount);
        }

        @Override
        public boolean test(FluidStack stack) {
            return this.ingredient == stack.getFluid();
        }

        public Fluid sample() {
            return new Fluid((net.minecraft.world.level.material.Fluid)this.ingredient, this.amount);
        }

        @Override
        public boolean checkType(Object obj) {
            return obj instanceof FluidStack;
        }

        @Override
        public int getStackAmount(FluidStack stack) {
            return stack.getAmount();
        }

        @Override
        public void setStackAmount(FluidStack stack, int amount) {
            stack.setAmount(amount);
        }

        public FluidStack getStack() {
            return new FluidStack((net.minecraft.world.level.material.Fluid)this.ingredient, this.amount);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.m_272073_(CODEC, (Object)this);
        }

        @Override
        public JsonElement toJson() {
            return ((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().get()).getAsJsonObject();
        }

        public static Fluid fromNetwork(FriendlyByteBuf buffer) {
            return (Fluid)buffer.m_271872_(CODEC);
        }

        public static Fluid fromJson(@Nullable JsonElement json) {
            return (Fluid)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result().get();
        }
    }
}

