/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.network.toclient;

import de.srendi.advancedperipherals.common.blocks.blockentities.InventoryManagerEntity;
import de.srendi.advancedperipherals.network.base.IPacket;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class InventoryManagerUpdatePacket
implements IPacket {
    public boolean hasOwner;
    public UUID owner;
    public BlockPos pos;

    public InventoryManagerUpdatePacket(boolean hasOwner, UUID owner, BlockPos pos) {
        this.hasOwner = hasOwner;
        this.owner = owner;
        this.pos = pos;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        Minecraft minecraft = Minecraft.m_91087_();
        BlockEntity blockEntity = minecraft.f_91073_.m_7702_(this.pos);
        if (blockEntity instanceof InventoryManagerEntity) {
            InventoryManagerEntity inventoryManagerEntity = (InventoryManagerEntity)blockEntity;
            inventoryManagerEntity.setOwner(this.hasOwner ? this.owner : null);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.hasOwner);
        if (this.hasOwner) {
            buffer.m_130077_(this.owner);
        }
        buffer.m_130064_(this.pos);
    }

    public static InventoryManagerUpdatePacket decode(FriendlyByteBuf buffer) {
        boolean hasOwner;
        return new InventoryManagerUpdatePacket(hasOwner, (hasOwner = buffer.readBoolean()) ? buffer.m_130259_() : null, buffer.m_130135_());
    }
}

