/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.service;

import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridService;
import appeng.api.networking.IGridServiceProvider;
import com.glodblock.github.appflux.common.me.service.IEnergyDistributor;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EnergyDistributeService
implements IGridService,
IGridServiceProvider {
    private final Map<IGridNode, IEnergyDistributor> distributors = new IdentityHashMap<IGridNode, IEnergyDistributor>();
    private final Set<IEnergyDistributor> activeNodes = Collections.newSetFromMap(new IdentityHashMap());

    public void onLevelEndTick(Level level) {
        for (IEnergyDistributor dis : this.activeNodes) {
            if (!dis.isActive()) continue;
            dis.distribute();
            dis.charge();
        }
    }

    public void removeNode(IGridNode gridNode) {
        IEnergyDistributor node = this.distributors.get(gridNode);
        if (node != null) {
            node.setServiceHost(null);
            this.activeNodes.remove(node);
            this.distributors.remove(gridNode);
        }
    }

    public void addNode(IGridNode gridNode, @Nullable CompoundTag savedData) {
        IEnergyDistributor distributor = (IEnergyDistributor)gridNode.getService(IEnergyDistributor.class);
        if (distributor != null) {
            this.distributors.put(gridNode, distributor);
            distributor.setServiceHost(this);
        }
    }

    public void wake(IEnergyDistributor node) {
        this.activeNodes.add(node);
    }

    public void sleep(IEnergyDistributor node) {
        this.activeNodes.remove(node);
    }
}

