/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.parts;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import com.glodblock.github.appflux.AppFlux;
import com.glodblock.github.appflux.common.me.energy.CapAdaptor;
import com.glodblock.github.appflux.common.me.energy.EnergyHandler;
import com.glodblock.github.appflux.common.me.service.EnergyDistributeService;
import com.glodblock.github.appflux.common.me.service.IEnergyDistributor;
import com.glodblock.github.appflux.config.AFConfig;
import com.glodblock.github.appflux.util.AFUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class PartFluxAccessor
extends AEBasePart
implements IEnergyDistributor {
    public static final ResourceLocation RL = AppFlux.id("part/flux_accessor");
    public static final IPartModel MODEL = new PartModel(RL);
    private CompoundTag extraData = new CompoundTag();
    private EnergyHandler.SendAction action = null;

    public PartFluxAccessor(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        this.getMainNode().setIdlePowerUsage(1.0).addService(IEnergyDistributor.class, (IGridNodeService)this);
    }

    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        Direction d = AFUtil.getBlockDirection(pos, neighbor);
        if (d == this.getSide()) {
            this.action = null;
        }
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 12.0, 12.0, 12.0, 14.0);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 2.0f;
    }

    public IPartModel getStaticModels() {
        return MODEL;
    }

    private IStorageService getStorage() {
        if (this.getGridNode() != null) {
            return this.getGridNode().getGrid().getStorageService();
        }
        return null;
    }

    private IActionSource getSource() {
        return IActionSource.ofMachine((IActionHost)this);
    }

    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.extraData = data.m_128469_("ex_dt");
    }

    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.m_128365_("ex_dt", (Tag)this.extraData);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        CapAdaptor.Factory handler = CapAdaptor.find(cap);
        if (handler != null) {
            return LazyOptional.of(() -> handler.create(this.getStorage(), this.getSource(), () -> this.extraData));
        }
        return super.getCapability(cap);
    }

    @Override
    public void distribute() {
        IGrid gird;
        IStorageService storage = this.getStorage();
        Direction d = this.getSide();
        IGrid iGrid = gird = this.getGridNode() == null ? null : this.getGridNode().getGrid();
        if (storage != null && d != null && this.getLevel() != null) {
            if (this.action == null) {
                BlockEntity te = this.getLevel().m_7702_(this.getBlockEntity().m_58899_().m_121955_(d.m_122436_()));
                IGrid thatGrid = AFUtil.getGrid(te, d.m_122424_());
                this.action = te != null && thatGrid != gird && !AFUtil.isBlackListTE(te, d.m_122424_()) ? EnergyHandler.getHandler(te, d.m_122424_()) : EnergyHandler.SendAction.NOOP;
            }
            this.action.send(storage, this.getSource());
        }
    }

    @Override
    public void charge() {
        if (AFConfig.selfCharge()) {
            IGrid gird;
            IStorageService storage = this.getStorage();
            Direction d = this.getSide();
            IGrid iGrid = gird = this.getGridNode() == null ? null : this.getGridNode().getGrid();
            if (storage != null && d != null && this.getLevel() != null && gird != null) {
                EnergyHandler.chargeNetwork((IEnergyService)gird.getService(IEnergyService.class), storage, this.getSource());
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.getMainNode().isActive();
    }

    @Override
    public void setServiceHost(@Nullable EnergyDistributeService service) {
        if (service != null) {
            service.wake(this);
        }
    }
}

