/*
 * Decompiled with CFR 0.152.
 */
package ballistix.api.capability;

import ballistix.api.missile.virtual.VirtualMissile;
import ballistix.registers.BallistixCapabilities;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityActiveMissiles
implements ICapabilitySerializable<CompoundTag> {
    public final HashMap<ResourceKey<Level>, HashMap<UUID, VirtualMissile>> activeMissiles = new HashMap();
    private final LazyOptional<CapabilityActiveMissiles> lazyOptional = LazyOptional.of(() -> this);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == BallistixCapabilities.ACTIVE_MISSILES) {
            return this.lazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag data = new CompoundTag();
        data.m_128405_("size", this.activeMissiles.size());
        int i = 0;
        for (Map.Entry<ResourceKey<Level>, HashMap<UUID, VirtualMissile>> entry : this.activeMissiles.entrySet()) {
            if (entry.getValue().size() <= 0) continue;
            CompoundTag stored = new CompoundTag();
            stored.m_128359_("key", entry.getKey().m_135782_().toString());
            int activeSize = entry.getValue().size();
            stored.m_128405_("size", activeSize);
            int j = 0;
            for (VirtualMissile missile : entry.getValue().values()) {
                int index = j++;
                VirtualMissile.CODEC.encode((Object)missile, (DynamicOps)NbtOps.f_128958_, (Object)new CompoundTag()).result().ifPresent(tag -> stored.m_128365_("" + index, tag));
            }
            data.m_128365_("" + i, (Tag)stored);
            ++i;
        }
        return data;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt == null) {
            return;
        }
        int size = nbt.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            CompoundTag stored = nbt.m_128469_("" + i);
            if (!stored.m_128441_("key")) continue;
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(stored.m_128461_("key")));
            HashMap<UUID, VirtualMissile> active = new HashMap<UUID, VirtualMissile>();
            int activeSize = stored.m_128451_("size");
            for (int j = 0; j < activeSize; ++j) {
                VirtualMissile virtual = (VirtualMissile)((Pair)VirtualMissile.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)stored.m_128469_("" + j)).result().get()).getFirst();
                active.put(virtual.getId(), virtual);
            }
            this.activeMissiles.put((ResourceKey<Level>)key, active);
        }
    }
}

