/*
 * Decompiled with CFR 0.152.
 */
package ballistix.api.missile.virtual;

import ballistix.api.blast.IBlast;
import ballistix.api.blast.IHasCustomRender;
import ballistix.api.missile.MissileManager;
import ballistix.api.silo.ILauncherPlatform;
import ballistix.api.silo.ILauncherSupportFrame;
import ballistix.common.blast.util.Blast;
import ballistix.common.block.subtype.SubtypeMissile;
import ballistix.common.entity.EntityBlast;
import ballistix.common.entity.EntityMissile;
import ballistix.common.settings.BallistixConstants;
import ballistix.registers.BallistixSounds;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import voltaic.api.multiblock.subnodebased.TileMultiSubnode;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.Scheduler;

public class VirtualMissile {
    public static final int MAX_CRUISING_ALTITUDE = 500;
    public static final int WORLD_BUILD_HEIGHT = 320;
    public static final int ARC_TURN_HEIGHT_MIN = 400;
    public static final Codec<VirtualMissile> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3.f_231074_.fieldOf("position").forGetter(instance0 -> instance0.position), (App)Vec3.f_231074_.fieldOf("movement").forGetter(instance0 -> instance0.deltaMovement), (App)Codec.FLOAT.fieldOf("speed").forGetter(instance0 -> Float.valueOf(instance0.speed)), (App)Codec.FLOAT.fieldOf("health").forGetter(instance0 -> Float.valueOf(instance0.health)), (App)Codec.BOOL.fieldOf("hasexploded").forGetter(instance0 -> instance0.hasExploded), (App)UUIDUtil.f_235867_.fieldOf("id").forGetter(instance0 -> instance0.id), (App)Codec.INT.fieldOf("tickcount").forGetter(instance0 -> instance0.tickCount), (App)MissileTargetData.CODEC.fieldOf("targetdata").forGetter(instance0 -> instance0.targetData), (App)MissileEntityData.CODEC.fieldOf("entitydata").forGetter(instance0 -> instance0.entityData), (App)MissilePayloadData.CODEC.fieldOf("payloaddata").forGetter(instance0 -> instance0.payloadData)).apply((Applicative)instance, VirtualMissile::new));
    public Vec3 position = Vec3.f_82478_;
    public Vec3 deltaMovement = Vec3.f_82478_;
    public float speed = 0.0f;
    public float health = BallistixConstants.MISSILE_HEALTH;
    private final UUID id;
    private boolean hasExploded = false;
    public final MissileEntityData entityData;
    public final MissileTargetData targetData;
    public final MissilePayloadData payloadData;
    private int tickCount = 0;
    @Nullable
    public EntityBlast blastEntity;

    private VirtualMissile(Vec3 pos, Vec3 deltaMovement, float speed, float health, boolean hasExploded, UUID id, int tickCount, MissileTargetData targetData, MissileEntityData entityData, MissilePayloadData payloadData) {
        this.position = pos;
        this.deltaMovement = deltaMovement;
        this.speed = speed;
        this.hasExploded = hasExploded;
        this.health = health;
        this.id = id;
        this.tickCount = tickCount;
        this.targetData = targetData;
        this.entityData = entityData;
        this.payloadData = payloadData;
    }

    public VirtualMissile(Vec3 startPos, Vec3 initialMovement, float initialSpeed, FlightPath flightPath, float startX, float startZ, BlockPos target, int missileType, IBlast blast, int frequency, boolean usingAirburst) {
        this.position = startPos;
        this.deltaMovement = initialMovement;
        this.speed = initialSpeed;
        this.id = UUID.randomUUID();
        this.targetData = new MissileTargetData(startX, startZ, target, false, usingAirburst);
        this.entityData = new MissileEntityData(false, -1);
        this.payloadData = new MissilePayloadData(missileType, blast.id(), frequency, flightPath.ordinal(), false);
    }

    public void tick(ServerLevel level) {
        ++this.tickCount;
        if (this.health <= 0.0f) {
            level.m_5594_(null, this.blockPosition(), SoundEvents.f_11913_, SoundSource.HOSTILE, 2.0f, 1.0f);
            this.hasExploded = true;
            return;
        }
        if (this.payloadData.getFlightPath() != FlightPath.ROCKET_LAUNCHER && this.targetData.target.equals((Object)BlockEntityUtils.OUT_OF_REACH) || this.payloadData.blastId == null) {
            this.hasExploded = true;
            return;
        }
        if (this.hasExploded) {
            return;
        }
        if (this.blastEntity != null) {
            if (this.blastEntity.m_213877_() || this.blastEntity.getBlast().hasStarted) {
                this.hasExploded = true;
            }
            return;
        }
        BlockPos collisionPos = this.projectMovementForCollision(level);
        if ((collisionPos != null || this.targetData.usingAirburst && this.targetData.pastHalfwayPoint && this.position.f_82480_ <= (double)this.targetData.target.m_123342_()) && (this.payloadData.getFlightPath() == FlightPath.ROCKET_LAUNCHER || !this.isInValidBlockstate(collisionPos, level)) || this.position.f_82480_ <= (double)level.m_141937_()) {
            Blast b;
            IBlast explosive = Blast.BLAST_MAP.get(this.payloadData.blastId);
            if (collisionPos == null) {
                collisionPos = new BlockPos((int)this.position.f_82479_, this.targetData.target.m_123342_(), (int)this.position.f_82481_);
            }
            if ((b = explosive.createBlast((Level)level, collisionPos)) != null) {
                if (b.isInstantaneous() && !(b instanceof IHasCustomRender)) {
                    b.performExplosion();
                    this.hasExploded = true;
                } else {
                    this.blastEntity = b.performExplosion();
                    if (!this.targetData.usingAirburst || this.targetData.usingAirburst && this.position.f_82480_ > (double)this.targetData.target.m_123342_()) {
                        this.position = new Vec3(this.position.f_82479_ - (double)this.speed * this.deltaMovement.f_82479_, this.position.f_82480_ - (double)this.speed * this.deltaMovement.f_82480_, this.position.f_82481_ - (double)this.speed * this.deltaMovement.f_82481_);
                    }
                }
                return;
            }
        }
        if (this.payloadData.getFlightPath() == FlightPath.SILO || this.payloadData.getFlightPath() == FlightPath.SILO_CLUSTER) {
            float iDeltaX = (float)this.targetData.target.m_123341_() - this.targetData.startX;
            float iDeltaZ = (float)this.targetData.target.m_123343_() - this.targetData.startZ;
            float initialDistance = (float)Math.sqrt(iDeltaX * iDeltaX + iDeltaZ * iDeltaZ);
            float halfwayDistance = initialDistance / 2.0f;
            float deltaX = (float)(this.position.f_82479_ - (double)this.targetData.startX);
            float deltaZ = (float)(this.position.f_82481_ - (double)this.targetData.startZ);
            float distanceTraveled = (float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            if (this.targetData.usingAirburst && distanceTraveled >= halfwayDistance) {
                this.targetData.pastHalfwayPoint = true;
            }
            double maxRadii = 100.0;
            float turnRadius = (float)Mth.m_14008_((double)halfwayDistance, (double)0.001f, (double)maxRadii);
            float deltaY = (float)(this.position.f_82480_ - 400.0);
            float phi = 0.0f;
            float signY = 1.0f;
            int sep = 5;
            if ((double)halfwayDistance <= maxRadii) {
                if (this.position.f_82480_ >= 400.0 && distanceTraveled < halfwayDistance) {
                    phi = (float)Math.asin(Mth.m_14036_((float)(deltaY / turnRadius), (float)0.0f, (float)1.0f));
                } else if (distanceTraveled >= halfwayDistance) {
                    if (this.payloadData.getFlightPath() == FlightPath.SILO_CLUSTER) {
                        VirtualMissile same = new VirtualMissile(this.position, this.deltaMovement, this.speed, this.health, false, UUID.randomUUID(), this.tickCount, this.targetData, new MissileEntityData(false, -1), new MissilePayloadData(SubtypeMissile.clustershard.ordinal(), this.payloadData.blastId, this.payloadData.frequency, FlightPath.SILO.ordinal(), false));
                        VirtualMissile above = new VirtualMissile(this.position.m_82520_((double)(-sep), (double)sep, (double)sep), this.deltaMovement, this.speed, this.health, false, UUID.randomUUID(), this.tickCount, new MissileTargetData(this.targetData.startX, this.targetData.startZ, this.targetData.target.m_7918_(-sep, 0, sep), this.targetData.pastHalfwayPoint, this.targetData.usingAirburst), new MissileEntityData(false, -1), new MissilePayloadData(SubtypeMissile.clustershard.ordinal(), this.payloadData.blastId, this.payloadData.frequency, FlightPath.SILO.ordinal(), false));
                        VirtualMissile below = new VirtualMissile(this.position.m_82520_((double)sep, (double)(-sep), (double)(-sep)), this.deltaMovement, this.speed, this.health, false, UUID.randomUUID(), this.tickCount, new MissileTargetData(this.targetData.startX, this.targetData.startZ, this.targetData.target.m_7918_(sep, 0, -sep), this.targetData.pastHalfwayPoint, this.targetData.usingAirburst), new MissileEntityData(false, -1), new MissilePayloadData(SubtypeMissile.clustershard.ordinal(), this.payloadData.blastId, this.payloadData.frequency, FlightPath.SILO.ordinal(), false));
                        VirtualMissile left = new VirtualMissile(this.position.m_82520_((double)sep, (double)sep, (double)(-sep)), this.deltaMovement, this.speed, this.health, false, UUID.randomUUID(), this.tickCount, new MissileTargetData(this.targetData.startX, this.targetData.startZ, this.targetData.target.m_7918_(-sep, 0, -sep), this.targetData.pastHalfwayPoint, this.targetData.usingAirburst), new MissileEntityData(false, -1), new MissilePayloadData(SubtypeMissile.clustershard.ordinal(), this.payloadData.blastId, this.payloadData.frequency, FlightPath.SILO.ordinal(), false));
                        VirtualMissile right = new VirtualMissile(this.position.m_82520_((double)(-sep), (double)(-sep), (double)sep), this.deltaMovement, this.speed, this.health, false, UUID.randomUUID(), this.tickCount, new MissileTargetData(this.targetData.startX, this.targetData.startZ, this.targetData.target.m_7918_(-sep, 0, -sep), this.targetData.pastHalfwayPoint, this.targetData.usingAirburst), new MissileEntityData(false, -1), new MissilePayloadData(SubtypeMissile.clustershard.ordinal(), this.payloadData.blastId, this.payloadData.frequency, FlightPath.SILO.ordinal(), false));
                        Scheduler.schedule((int)1, () -> {
                            MissileManager.addMissile((ResourceKey<Level>)level.m_46472_(), same);
                            MissileManager.addMissile((ResourceKey<Level>)level.m_46472_(), above);
                            MissileManager.addMissile((ResourceKey<Level>)level.m_46472_(), below);
                            MissileManager.addMissile((ResourceKey<Level>)level.m_46472_(), left);
                            MissileManager.addMissile((ResourceKey<Level>)level.m_46472_(), right);
                        });
                        this.hasExploded = true;
                        return;
                    }
                    phi = (float)Math.asin(Mth.m_14036_((float)((initialDistance - distanceTraveled) / turnRadius), (float)0.0f, (float)1.0f));
                    signY = -1.0f;
                } else if (distanceTraveled >= initialDistance) {
                    signY = -1.0f;
                }
                float x = (float)((double)(iDeltaX / initialDistance) * Math.sin(phi));
                float z = (float)((double)(iDeltaZ / initialDistance) * Math.sin(phi));
                this.deltaMovement = new Vec3((double)x, Math.cos(phi) * (double)signY, (double)z);
            } else {
                if (this.position.f_82480_ >= 400.0 && distanceTraveled < halfwayDistance) {
                    phi = distanceTraveled <= turnRadius ? (float)Math.asin(Mth.m_14036_((float)(deltaY / turnRadius), (float)0.0f, (float)1.0f)) : 1.5707964f;
                } else if (distanceTraveled >= halfwayDistance) {
                    if (distanceTraveled >= initialDistance - turnRadius) {
                        if (this.payloadData.getFlightPath() == FlightPath.SILO_CLUSTER) {
                            VirtualMissile same = new VirtualMissile(this.position, this.deltaMovement, this.speed, this.health, false, UUID.randomUUID(), this.tickCount, this.targetData, new MissileEntityData(false, -1), new MissilePayloadData(SubtypeMissile.clustershard.ordinal(), this.payloadData.blastId, this.payloadData.frequency, FlightPath.SILO.ordinal(), false));
                            VirtualMissile above = new VirtualMissile(this.position.m_82520_((double)(-sep), (double)sep, (double)sep), this.deltaMovement, this.speed, this.health, false, UUID.randomUUID(), this.tickCount, new MissileTargetData(this.targetData.startX, this.targetData.startZ, this.targetData.target.m_7918_(-sep, 0, sep), this.targetData.pastHalfwayPoint, this.targetData.usingAirburst), new MissileEntityData(false, -1), new MissilePayloadData(SubtypeMissile.clustershard.ordinal(), this.payloadData.blastId, this.payloadData.frequency, FlightPath.SILO.ordinal(), false));
                            VirtualMissile below = new VirtualMissile(this.position.m_82520_((double)sep, (double)(-sep), (double)(-sep)), this.deltaMovement, this.speed, this.health, false, UUID.randomUUID(), this.tickCount, new MissileTargetData(this.targetData.startX, this.targetData.startZ, this.targetData.target.m_7918_(sep, 0, -sep), this.targetData.pastHalfwayPoint, this.targetData.usingAirburst), new MissileEntityData(false, -1), new MissilePayloadData(SubtypeMissile.clustershard.ordinal(), this.payloadData.blastId, this.payloadData.frequency, FlightPath.SILO.ordinal(), false));
                            VirtualMissile left = new VirtualMissile(this.position.m_82520_((double)sep, (double)sep, (double)(-sep)), this.deltaMovement, this.speed, this.health, false, UUID.randomUUID(), this.tickCount, new MissileTargetData(this.targetData.startX, this.targetData.startZ, this.targetData.target.m_7918_(-sep, 0, -sep), this.targetData.pastHalfwayPoint, this.targetData.usingAirburst), new MissileEntityData(false, -1), new MissilePayloadData(SubtypeMissile.clustershard.ordinal(), this.payloadData.blastId, this.payloadData.frequency, FlightPath.SILO.ordinal(), false));
                            VirtualMissile right = new VirtualMissile(this.position.m_82520_((double)(-sep), (double)(-sep), (double)sep), this.deltaMovement, this.speed, this.health, false, UUID.randomUUID(), this.tickCount, new MissileTargetData(this.targetData.startX, this.targetData.startZ, this.targetData.target.m_7918_(-sep, 0, -sep), this.targetData.pastHalfwayPoint, this.targetData.usingAirburst), new MissileEntityData(false, -1), new MissilePayloadData(SubtypeMissile.clustershard.ordinal(), this.payloadData.blastId, this.payloadData.frequency, FlightPath.SILO.ordinal(), false));
                            Scheduler.schedule((int)1, () -> {
                                MissileManager.addMissile((ResourceKey<Level>)level.m_46472_(), same);
                                MissileManager.addMissile((ResourceKey<Level>)level.m_46472_(), above);
                                MissileManager.addMissile((ResourceKey<Level>)level.m_46472_(), below);
                                MissileManager.addMissile((ResourceKey<Level>)level.m_46472_(), left);
                                MissileManager.addMissile((ResourceKey<Level>)level.m_46472_(), right);
                            });
                            this.hasExploded = true;
                            return;
                        }
                        phi = (float)Math.asin(Mth.m_14036_((float)((initialDistance - distanceTraveled) / turnRadius), (float)0.0f, (float)1.0f));
                        signY = -1.0f;
                    } else {
                        phi = 1.5707964f;
                    }
                } else if (distanceTraveled >= initialDistance) {
                    signY = -1.0f;
                }
                float x = (float)((double)(iDeltaX / initialDistance) * Math.sin(phi));
                float z = (float)((double)(iDeltaZ / initialDistance) * Math.sin(phi));
                this.deltaMovement = new Vec3((double)x, Math.cos(phi) * (double)signY, (double)z);
            }
        } else if (this.payloadData.getFlightPath() == FlightPath.VLS) {
            if (!this.payloadData.hasIgnighted && (double)this.speed > -0.15) {
                this.speed -= 0.03f;
            } else if (!this.payloadData.hasIgnighted) {
                this.payloadData.hasIgnighted = true;
                level.m_5594_(null, this.blockPosition(), (SoundEvent)BallistixSounds.SOUND_MISSILE_SILO.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if ((double)this.speed > 0.5) {
                Vec3 desiredVector = new Vec3((double)this.targetData.target.m_123341_() - this.position.f_82479_, (double)this.targetData.target.m_123342_() - this.position.f_82480_, (double)this.targetData.target.m_123343_() - this.position.f_82481_).m_82541_();
                Vec3 currVector = this.deltaMovement.m_82541_();
                double dotProduct = desiredVector.m_82526_(currVector);
                double maxTurnRadians = 0.05;
                if (dotProduct != 0.0) {
                    if (Math.acos(dotProduct) <= maxTurnRadians) {
                        this.deltaMovement = desiredVector;
                    } else {
                        Vec3 perpVector = currVector.m_82537_(desiredVector).m_82537_(currVector).m_82541_();
                        Vec3 result = currVector.m_82490_(Math.cos(maxTurnRadians)).m_82549_(perpVector.m_82490_(Math.sin(maxTurnRadians)));
                        this.deltaMovement = result.m_82541_();
                    }
                }
            }
        }
        if (this.blastEntity == null) {
            this.position = new Vec3(this.position.f_82479_ + (double)this.speed * this.deltaMovement.f_82479_, this.position.f_82480_ + (double)this.speed * this.deltaMovement.f_82480_, this.position.f_82481_ + (double)this.speed * this.deltaMovement.f_82481_);
        }
        if ((this.payloadData.getFlightPath() == FlightPath.SILO || this.payloadData.getFlightPath() == FlightPath.SILO_CLUSTER || this.payloadData.getFlightPath() == FlightPath.VLS && this.payloadData.hasIgnighted) && !this.targetData.target.equals((Object)BlockEntityUtils.OUT_OF_REACH) && this.speed < 3.0f) {
            this.speed += 0.02f;
        }
        if (!this.entityData.isSpawned && level.m_46805_(this.blockPosition()) && level.m_143340_(this.blockPosition())) {
            EntityMissile missile = new EntityMissile((Level)level);
            missile.m_146884_(this.position);
            missile.m_20256_(this.deltaMovement);
            missile.missileType = this.payloadData.missileType;
            missile.speed = this.speed;
            missile.id = this.id;
            missile.flightPath = this.payloadData.flightPath;
            missile.target = this.targetData.target;
            missile.startX = this.targetData.startX;
            missile.startZ = this.targetData.startZ;
            if (level.m_7967_((Entity)missile)) {
                this.setSpawned(true, missile.m_19879_());
            }
        }
        if (this.entityData.isSpawned && (!level.m_46805_(this.blockPosition()) || level.m_6815_(this.entityData.entityId) == null)) {
            this.setSpawned(false, -1);
        }
    }

    private boolean isInValidBlockstate(BlockPos pos, ServerLevel world) {
        if (pos == null) {
            return true;
        }
        BlockEntity blockentity = world.m_7702_(pos);
        if (blockentity instanceof ILauncherPlatform || blockentity instanceof ILauncherSupportFrame) {
            return true;
        }
        if (blockentity instanceof TileMultiSubnode) {
            TileMultiSubnode subnode = (TileMultiSubnode)blockentity;
            BlockEntity owner = world.m_7702_((BlockPos)subnode.parentPos.getValue());
            return owner instanceof ILauncherPlatform || owner instanceof ILauncherSupportFrame;
        }
        return false;
    }

    public BlockPos blockPosition() {
        return new BlockPos((int)Math.floor(this.position.f_82479_), (int)Math.floor(this.position.f_82480_), (int)Math.floor(this.position.f_82481_));
    }

    public UUID getId() {
        return this.id;
    }

    public boolean hasExploded() {
        return this.hasExploded;
    }

    public void setSpawned(boolean spawned, int id) {
        this.entityData.isSpawned = spawned;
        this.entityData.entityId = id;
    }

    public AABB getBoundingBox() {
        return new AABB(this.position.f_82479_ - 0.5, this.position.f_82480_, this.position.f_82481_ - 0.5, this.position.f_82479_ + 0.5, this.position.f_82480_ + 1.0, this.position.f_82481_ + 0.5);
    }

    @Nullable
    public BlockPos projectMovementForCollision(ServerLevel world) {
        Vec3 currPos = this.position.m_82490_(1.0);
        int iterations = Math.abs((int)Math.ceil(this.speed));
        for (int i = 0; i < iterations; ++i) {
            BlockPos pos = new BlockPos((int)Math.floor(currPos.f_82479_), (int)Math.floor(currPos.f_82480_), (int)Math.floor(currPos.f_82481_));
            BlockState state = world.m_8055_(pos);
            if (!state.m_60812_((BlockGetter)world, this.blockPosition()).m_83281_() && !this.isInValidBlockstate(pos, world)) {
                return pos;
            }
            currPos.m_82549_(this.deltaMovement);
        }
        return null;
    }

    public static class MissileTargetData {
        public static final Codec<MissileTargetData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("startx").forGetter(instance0 -> Float.valueOf(instance0.startX)), (App)Codec.FLOAT.fieldOf("startz").forGetter(instance0 -> Float.valueOf(instance0.startZ)), (App)BlockPos.f_121852_.fieldOf("target").forGetter(instance0 -> instance0.target), (App)Codec.BOOL.fieldOf("pasthalfwaypoint").forGetter(instance0 -> instance0.pastHalfwayPoint), (App)Codec.BOOL.fieldOf("usingairburst").forGetter(instance0 -> instance0.usingAirburst)).apply((Applicative)instance, MissileTargetData::new));
        public final float startX;
        public final float startZ;
        public final BlockPos target;
        public boolean pastHalfwayPoint = false;
        public final boolean usingAirburst;

        public MissileTargetData(float startX, float startZ, BlockPos target, boolean pastHalfway, boolean usingAirburst) {
            this.startX = startX;
            this.startZ = startZ;
            this.target = target;
            this.pastHalfwayPoint = pastHalfway;
            this.usingAirburst = usingAirburst;
        }
    }

    public static class MissileEntityData {
        public static final Codec<MissileEntityData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("isspawned").forGetter(instance0 -> instance0.isSpawned), (App)Codec.INT.fieldOf("entityid").forGetter(instance0 -> instance0.entityId)).apply((Applicative)instance, MissileEntityData::new));
        public boolean isSpawned = false;
        public int entityId = -1;

        public MissileEntityData(boolean isSpawned, int entityId) {
            this.entityId = entityId;
            this.isSpawned = isSpawned;
        }
    }

    public static class MissilePayloadData {
        public static final Codec<MissilePayloadData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("missiletype").forGetter(instance0 -> instance0.missileType), (App)ResourceLocation.f_135803_.fieldOf("blastid").forGetter(instance0 -> instance0.blastId), (App)Codec.INT.fieldOf("frequency").forGetter(instance0 -> instance0.frequency), (App)Codec.INT.fieldOf("fligthpath").forGetter(instance0 -> instance0.flightPath), (App)Codec.BOOL.fieldOf("hasignighted").forGetter(instance0 -> instance0.hasIgnighted)).apply((Applicative)instance, MissilePayloadData::new));
        public final int missileType;
        public final ResourceLocation blastId;
        public final int frequency;
        private final int flightPath;
        public boolean hasIgnighted;

        public MissilePayloadData(int missileType, ResourceLocation blastId, int frequency, int flightPath, boolean hasIgnighted) {
            this.missileType = missileType;
            this.blastId = blastId;
            this.frequency = frequency;
            this.flightPath = flightPath;
            this.hasIgnighted = hasIgnighted;
        }

        public FlightPath getFlightPath() {
            return FlightPath.values()[this.flightPath];
        }
    }

    public static enum FlightPath {
        ROCKET_LAUNCHER,
        VLS,
        SILO,
        SILO_CLUSTER;

    }
}

