/*
 * Decompiled with CFR 0.152.
 */
package ballistix.api.turret;

import ballistix.api.missile.virtual.VirtualMissile;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public interface ITarget<T> {
    public Vec3 getTargetLocation();

    default public BlockPos getTargetBlockPos() {
        return new BlockPos((int)Math.floor(this.getTargetLocation().f_82479_), (int)Math.floor(this.getTargetLocation().f_82480_), (int)Math.floor(this.getTargetLocation().f_82481_));
    }

    public float getTargetSpeed();

    public Vec3 getTargetMovement();

    public T getTarget();

    public record TargetLivingEntity(LivingEntity entity) implements ITarget<LivingEntity>
    {
        @Override
        public Vec3 getTargetLocation() {
            return new Vec3(this.entity.m_20185_(), this.entity.m_20186_() + (double)this.entity.m_20206_() * 0.75, this.entity.m_20189_());
        }

        @Override
        public float getTargetSpeed() {
            return 1.0f;
        }

        @Override
        public Vec3 getTargetMovement() {
            return this.entity.m_20184_();
        }

        @Override
        public LivingEntity getTarget() {
            return this.entity;
        }
    }

    public record TargetMissile(VirtualMissile missile) implements ITarget<VirtualMissile>
    {
        @Override
        public Vec3 getTargetLocation() {
            return this.missile.position;
        }

        @Override
        public float getTargetSpeed() {
            return this.missile.speed;
        }

        @Override
        public Vec3 getTargetMovement() {
            return this.missile.deltaMovement;
        }

        @Override
        public VirtualMissile getTarget() {
            return this.missile;
        }
    }
}

