/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier1;

import ballistix.common.blast.util.Blast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.settings.BallistixConstants;
import ballistix.compatibility.griefdefender.GriefDefenderHandler;
import ballistix.registers.BallistixDamageTypes;
import ballistix.registers.BallistixEffects;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;

public class BlastChemical
extends Blast {
    public BlastChemical(Level world, BlockPos position) {
        super(world, position);
    }

    @Override
    public boolean isInstantaneous() {
        return false;
    }

    @Override
    public void doPreExplode() {
        if (!this.world.f_46443_) {
            this.world.m_5594_(null, this.position, SoundEvents.f_11913_, SoundSource.BLOCKS, 25.0f, 1.0f);
        }
    }

    @Override
    public boolean doExplode(int callCount) {
        this.hasStarted = true;
        int radius = (int)BallistixConstants.EXPLOSIVE_CHEMICAL_SIZE;
        if (this.world.f_46443_ && callCount % 3 == 0) {
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        boolean add;
                        double xPos = (double)(this.position.m_123341_() + x) + 0.5 + this.world.f_46441_.m_188500_() - 1.0;
                        double yPos = (double)(this.position.m_123342_() + y) + 0.5 + this.world.f_46441_.m_188500_() - 1.0;
                        double zPos = (double)(this.position.m_123343_() + z) + 0.5 + this.world.f_46441_.m_188500_() - 1.0;
                        switch (this.griefPreventionMethod) {
                            case GRIEF_DEFENDER: {
                                boolean bl = GriefDefenderHandler.shouldAddParticle(new BlockPos((int)xPos, (int)yPos, (int)zPos));
                                break;
                            }
                            default: {
                                boolean bl = add = true;
                            }
                        }
                        if (!add || x * x + y * y + z * z >= radius * radius || !(this.world.f_46441_.m_188500_() < 0.1)) continue;
                        Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)new DustParticleOptions(new Vector3f(0.7f, 0.8f, 0.0f), 5.0f), xPos, yPos, zPos, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        if (!this.world.f_46443_) {
            float x = this.position.m_123341_();
            float y = this.position.m_123342_();
            float z = this.position.m_123343_();
            int x0 = Mth.m_14107_((double)((double)x - (double)radius - 1.0));
            int x1 = Mth.m_14107_((double)((double)x + (double)radius + 1.0));
            int y0 = Mth.m_14107_((double)((double)y - (double)radius - 1.0));
            int y1 = Mth.m_14107_((double)((double)y + (double)radius + 1.0));
            int z0 = Mth.m_14107_((double)((double)z - (double)radius - 1.0));
            int z1 = Mth.m_14107_((double)((double)z + (double)radius + 1.0));
            List entities = this.world.m_45933_(null, new AABB((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1));
            block9: for (Entity entity : entities) {
                switch (this.griefPreventionMethod) {
                    case GRIEF_DEFENDER: {
                        if (GriefDefenderHandler.shouldEntityBeHarmed(entity)) break;
                        continue block9;
                    }
                }
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 360, 2));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 360));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 360, 2));
                living.m_7292_(new MobEffectInstance((MobEffect)BallistixEffects.TOXIN.get(), 360));
                if (callCount % 10 != 0) continue;
                living.m_6469_(living.m_269291_().m_269079_(BallistixDamageTypes.CHEMICAL_GAS), 2.0f);
            }
        }
        return (double)callCount > BallistixConstants.EXPLOSIVE_CHEMICAL_DURATION;
    }

    @Override
    public SubtypeBlast getBlastType() {
        return SubtypeBlast.chemical;
    }
}

