/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier1;

import ballistix.api.blast.IHasCustomRender;
import ballistix.common.blast.util.Blast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.settings.BallistixConstants;
import ballistix.compatibility.griefdefender.GriefDefenderHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlastIncendiary
extends Blast
implements IHasCustomRender {
    public BlastIncendiary(Level world, BlockPos position) {
        super(world, position);
    }

    @Override
    public void doPreExplode() {
        if (!this.world.f_46443_) {
            this.world.m_5594_(null, this.position, SoundEvents.f_11913_, SoundSource.BLOCKS, 25.0f, 1.0f);
        }
    }

    @Override
    public boolean doExplode(int callCount) {
        super.doExplode(callCount);
        this.hasStarted = true;
        if (this.world.f_46443_) {
            this.produceParticles();
            return true;
        }
        int radius = (int)BallistixConstants.EXPLOSIVE_INCENDIARY_RADIUS;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    boolean add;
                    if (x * x + y * y + z * z >= radius * radius) continue;
                    int xActual = this.position.m_123341_() + x;
                    int yActual = this.position.m_123342_() + y;
                    int zActual = this.position.m_123343_() + z;
                    BlockPos pos = new BlockPos(xActual, yActual, zActual);
                    switch (this.griefPreventionMethod) {
                        case GRIEF_DEFENDER: {
                            boolean bl = GriefDefenderHandler.shouldHarmBlock(pos);
                            break;
                        }
                        default: {
                            boolean bl = add = true;
                        }
                    }
                    if (!add || !this.world.m_46859_(pos) || this.world.m_46859_(pos.m_121945_(Direction.DOWN))) continue;
                    this.world.m_46597_(pos, Blocks.f_50083_.m_49966_());
                }
            }
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void produceParticles() {
    }

    @Override
    public SubtypeBlast getBlastType() {
        return SubtypeBlast.incendiary;
    }
}

