/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier2;

import ballistix.api.blast.IHasCustomRender;
import ballistix.client.particle.ParticleOptionsBlastSmoke;
import ballistix.client.shake.CameraShakeEffect;
import ballistix.client.shake.CameraShakeManager;
import ballistix.common.blast.util.BlastLasting;
import ballistix.common.blast.util.thread.raycast.ThreadRaycastBlast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.settings.BallistixConstants;
import ballistix.compatibility.griefdefender.GriefDefenderHandler;
import ballistix.prefab.utils.ParticleUtilities;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlastBreaching
extends BlastLasting
implements IHasCustomRender {
    private ThreadRaycastBlast thread;
    private Iterator<BlockPos> iterator;
    private int pertick = -1;
    private boolean hasShaken;

    public BlastBreaching(Level world, BlockPos position) {
        super(world, position);
    }

    @Override
    public void doPreExplode() {
        if (!this.world.f_46443_) {
            this.thread = new ThreadRaycastBlast(this.world, this.position, (int)BallistixConstants.EXPLOSIVE_BREACHING_SIZE, (float)BallistixConstants.EXPLOSIVE_BREACHING_ENERGY, null);
            this.thread.start();
            this.world.m_254849_(null, (double)this.position.m_123341_() + 0.5, (double)this.position.m_123342_() + 0.5, (double)this.position.m_123343_() + 0.5, (float)BallistixConstants.EXPLOSIVE_BREACHING_SIZE, Level.ExplosionInteraction.BLOCK);
            this.world.m_5594_(null, this.position, SoundEvents.f_11913_, SoundSource.BLOCKS, 25.0f, 1.0f);
        }
    }

    @Override
    public boolean doExplode(int callCount) {
        this.hasStarted = true;
        super.doExplode(callCount);
        if (this.thread == null) {
            return (double)this.ticksSinceBlastStart > BallistixConstants.EXPLOSIVE_BREACHING_SIZE * 3.0;
        }
        if (this.world.f_46443_ || !this.thread.isComplete) {
            return (double)this.ticksSinceBlastStart > BallistixConstants.EXPLOSIVE_BREACHING_SIZE * 3.0;
        }
        if (this.pertick == -1) {
            this.hasStarted = true;
            this.pertick = (int)((double)this.thread.results.size() * 1.5 / BallistixConstants.EXPLOSIVE_BREACHING_DURATION + 1.0);
            this.iterator = this.thread.results.iterator();
        }
        int finished = this.pertick;
        while (this.iterator.hasNext() && finished-- >= 0) {
            BlockPos p = new BlockPos((Vec3i)this.iterator.next()).m_121955_((Vec3i)this.position);
            BlockState state = this.world.m_8055_(p);
            if (state.m_60795_()) continue;
            boolean shouldDestroy = true;
            switch (this.griefPreventionMethod) {
                case NONE: {
                    break;
                }
                case GRIEF_DEFENDER: {
                    shouldDestroy = GriefDefenderHandler.shouldHarmBlock(p);
                    break;
                }
            }
            if (!shouldDestroy) continue;
            this.world.m_46597_(p, Blocks.f_50016_.m_49966_());
        }
        return (double)this.ticksSinceBlastStart > BallistixConstants.EXPLOSIVE_BREACHING_SIZE * 3.0;
    }

    @Override
    public boolean isInstantaneous() {
        return false;
    }

    @Override
    public SubtypeBlast getBlastType() {
        return SubtypeBlast.breaching;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void produceParticles() {
        double spawnSize;
        double endSize;
        int diff;
        double x = (double)this.position.m_123341_() + 0.5;
        double y = this.position.m_123342_() - 2;
        double z = (double)this.position.m_123343_() + 0.5;
        if (this.ticksSinceBlastStart == 1) {
            double initialSpeed = 0.4;
            ParticleOptionsBlastSmoke particle = new ParticleOptionsBlastSmoke().setParameters(1.0f, 1.0f, 1.0f, 1.0f, -0.045f, 200, true, true, 20, 0.95);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 100, 40.0, 90.0, initialSpeed, true);
            initialSpeed = 0.4;
            particle = new ParticleOptionsBlastSmoke().setParameters(1.0f, 1.0f, 1.0f, 1.0f, 0.033f, 200, true, 0.95);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 100, 0.0, 20.0, initialSpeed, true);
            initialSpeed = 0.4;
            particle = new ParticleOptionsBlastSmoke().setParameters(1.0f, 1.0f, 1.0f, 1.0f, -0.033f, 200, true, 0.95);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 100, 0.0, 20.0, initialSpeed, true);
        }
        if (this.ticksSinceBlastStart > (diff = (int)((endSize = BallistixConstants.EXPLOSIVE_BREACHING_SIZE * 5.0) - (spawnSize = 3.0)))) {
            return;
        }
        double size = ParticleUtilities.progressGroundShockwave(this.world, x, z, (double)(this.ticksSinceBlastStart * 2) / (double)diff, spawnSize, endSize, 0.2);
        if (this.hasShaken) {
            return;
        }
        Vec3 pos = new Vec3(x, y, z);
        double realDistance = Minecraft.m_91087_().f_91074_.m_20182_().m_82554_(pos);
        double dist = Mth.m_14154_((float)((float)(realDistance - size)));
        if (dist < 3.0) {
            this.hasShaken = true;
            CameraShakeEffect effect = CameraShakeManager.createBlastSourcedEffect(20.0, endSize, this.world.m_46467_(), pos);
            CameraShakeManager.addShake(effect);
        }
    }

    @Override
    public boolean isDoneCalculating() {
        if (this.world.f_46443_) {
            return this.shouldRenderCustomClient;
        }
        return true;
    }
}

