/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier2;

import ballistix.api.blast.IHasCustomRender;
import ballistix.client.particle.ParticleOptionsBlastSmoke;
import ballistix.client.shake.CameraShakeEffect;
import ballistix.client.shake.CameraShakeManager;
import ballistix.common.blast.util.BlastLasting;
import ballistix.common.blast.util.thread.raycast.ThreadDynamicRaycastBlast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.packet.NetworkHandler;
import ballistix.common.packet.type.client.particle.BlastParticleSpawnType;
import ballistix.common.packet.type.client.particle.PacketSpawnBlastParticle;
import ballistix.common.settings.BallistixConstants;
import ballistix.compatibility.griefdefender.GriefDefenderHandler;
import ballistix.prefab.utils.ParticleUtilities;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;

public class BlastThermobaric
extends BlastLasting
implements IHasCustomRender {
    private ThreadDynamicRaycastBlast thread;
    private int pertick = -1;
    private Iterator<BlockPos> cachedIterator;
    private boolean hasShaken = false;

    public BlastThermobaric(Level world, BlockPos position) {
        super(world, position);
    }

    @Override
    public void doPreExplode() {
        if (!this.world.f_46443_) {
            this.thread = new ThreadDynamicRaycastBlast(this.world, this.position, (int)BallistixConstants.EXPLOSIVE_THERMOBARIC_SIZE, (float)BallistixConstants.EXPLOSIVE_THERMOBARIC_ENERGY, null);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doExplode(int callCount) {
        super.doExplode(callCount);
        if (this.thread == null) {
            return !this.world.f_46443_;
        }
        if (callCount % 2 == 0) {
            Explosion ex = new Explosion(this.world, null, null, null, (double)this.position.m_123341_(), (double)this.position.m_123342_(), (double)this.position.m_123343_(), (float)BallistixConstants.EXPLOSIVE_THERMOBARIC_SIZE, false, Explosion.BlockInteraction.DESTROY);
            Set<BlockPos> set = this.thread.finishedBlocks;
            synchronized (set) {
                if (this.pertick == -1) {
                    this.hasStarted = true;
                    this.attackEntities((float)BallistixConstants.EXPLOSIVE_THERMOBARIC_SIZE * 2.0f, ex);
                    this.world.m_5594_(null, this.position, SoundEvents.f_11913_, SoundSource.BLOCKS, 25.0f, 1.0f);
                    this.pertick = (int)(54000.0 / BallistixConstants.EXPLOSIVE_THERMOBARIC_DURATION);
                }
                this.cachedIterator = this.thread.finishedBlocks.iterator();
                int finished = this.pertick;
                while (this.cachedIterator.hasNext() && finished-- >= 0) {
                    Level level;
                    BlockPos p = this.cachedIterator.next();
                    Block block = this.world.m_8055_(p).m_60734_();
                    switch (this.griefPreventionMethod) {
                        case NONE: {
                            block.m_7592_(this.world, p, ex);
                            this.world.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
                            break;
                        }
                        case GRIEF_DEFENDER: {
                            GriefDefenderHandler.destroyBlock(block, ex, p, this.world);
                            break;
                        }
                    }
                    if ((double)this.world.f_46441_.m_188501_() < 0.05 && (level = this.world) instanceof ServerLevel) {
                        ServerLevel serverlevel = (ServerLevel)level;
                        serverlevel.m_7726_().f_8325_.m_183262_(new ChunkPos(p), false).forEach(pl -> NetworkHandler.CHANNEL.sendTo((Object)new PacketSpawnBlastParticle(p, BlastParticleSpawnType.EXPLOSIVE_BLOCK_BREAK), pl.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
                    }
                    this.cachedIterator.remove();
                }
                if (!this.cachedIterator.hasNext() && this.thread.isComplete) {
                    this.attackEntities((float)BallistixConstants.EXPLOSIVE_THERMOBARIC_SIZE * 2.0f, ex);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void produceParticles() {
        double spawnSize;
        double endSize;
        int diff;
        double x = (double)this.position.m_123341_() + 0.5;
        double y = (double)this.position.m_123342_() + 0.5;
        double z = (double)this.position.m_123343_() + 0.5;
        double initialSpeed = 0.8;
        if (this.ticksSinceBlastStart <= 5) {
            ParticleOptionsBlastSmoke particle = new ParticleOptionsBlastSmoke().setParameters(1.0f, 1.0f, 1.0f, 2.0f, -0.045f, 750, true, true, 40, 0.95);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 100, 50.0, 90.0, initialSpeed, true);
            initialSpeed = 1.0;
            particle = new ParticleOptionsBlastSmoke().setParameters(0.8f, 0.8f, 0.8f, 2.5f, 0.033f, 750, true, 0.95);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 100, 0.0, 20.0, initialSpeed, true);
            initialSpeed = 1.0;
            particle = new ParticleOptionsBlastSmoke().setParameters(0.8f, 0.8f, 0.8f, 2.5f, -0.033f, 750, true, 0.95);
            ParticleUtilities.spawnParticleSphere(particle, x, y, z, 100, 0.0, 20.0, initialSpeed, true);
        }
        if (this.ticksSinceBlastStart > (diff = (int)((endSize = BallistixConstants.EXPLOSIVE_THERMOBARIC_SIZE * 7.5) - (spawnSize = 3.0)))) {
            return;
        }
        double size = ParticleUtilities.progressGroundShockwave(this.world, x, z, (double)(this.ticksSinceBlastStart * 2) / (double)diff, spawnSize, endSize, 0.3);
        if (this.hasShaken) {
            return;
        }
        Vec3 pos = new Vec3(x, y, z);
        double realDistance = Minecraft.m_91087_().f_91074_.m_20182_().m_82554_(pos);
        double dist = Mth.m_14154_((float)((float)(realDistance - size)));
        if (dist < 3.0) {
            this.hasShaken = true;
            CameraShakeEffect effect = CameraShakeManager.createBlastSourcedEffect(BallistixConstants.EXPLOSIVE_THERMOBARIC_DURATION / 1.5, endSize, this.world.m_46467_(), pos);
            CameraShakeManager.addShake(effect);
        }
    }

    @Override
    public boolean isInstantaneous() {
        return false;
    }

    @Override
    public SubtypeBlast getBlastType() {
        return SubtypeBlast.thermobaric;
    }

    @Override
    public boolean isDoneCalculating() {
        if (this.world.f_46443_) {
            return this.shouldRenderCustomClient;
        }
        return this.thread == null || this.thread.isComplete;
    }

    @Override
    public boolean shouldRender() {
        return this.pertick > 0;
    }
}

