/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier3;

import ballistix.api.blast.IBlast;
import ballistix.api.blast.IMovingBlast;
import ballistix.common.blast.util.Blast;
import ballistix.common.blast.util.thread.ThreadSimpleBlast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.settings.BallistixConstants;
import ballistix.compatibility.griefdefender.GriefDefenderHandler;
import ballistix.registers.BallistixSounds;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import voltaic.prefab.utilities.WorldUtils;

public class BlastDarkmatter
extends Blast
implements IMovingBlast {
    public ThreadSimpleBlast thread;
    private int callAtStart = -1;
    private int pertick = -1;
    public boolean canceled = false;
    private Iterator<BlockPos> cachedIterator;

    public BlastDarkmatter(Level world, BlockPos position) {
        super(world, position);
    }

    @Override
    public void doPreExplode() {
        if (!this.world.f_46443_) {
            this.thread = new ThreadSimpleBlast(this.world, this.position, (int)BallistixConstants.EXPLOSIVE_DARKMATTER_RADIUS, 2.1474836E9f, null, this.getBlastType().id());
            this.thread.start();
            if (!this.isRepeating) {
                this.world.m_5594_(null, this.position, (SoundEvent)BallistixSounds.SOUND_DARKMATTER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public boolean doExplode(int callCount) {
        if (this.world.f_46443_) {
            return false;
        }
        this.hasStarted = true;
        if (this.thread == null || this.canceled) {
            return true;
        }
        Explosion ex = new Explosion(this.world, null, null, null, (double)this.position.m_123341_(), (double)this.position.m_123342_(), (double)this.position.m_123343_(), (float)BallistixConstants.EXPLOSIVE_DARKMATTER_RADIUS, false, Explosion.BlockInteraction.DESTROY);
        if (this.thread.isComplete) {
            if (this.callAtStart == -1) {
                this.callAtStart = callCount;
            }
            if (this.pertick == -1) {
                this.pertick = (int)((double)this.thread.results.size() / (this.isRepeating ? (double)BallistixConstants.EXPLOSIVE_DARKMATTER_REPEATDURATION : BallistixConstants.EXPLOSIVE_DARKMATTER_DURATION));
                this.cachedIterator = this.thread.results.iterator();
            }
            int finished = this.pertick;
            while (this.cachedIterator.hasNext() && finished-- >= 0) {
                BlockPos p = new BlockPos((Vec3i)this.cachedIterator.next()).m_121955_((Vec3i)this.position);
                BlockState state = this.world.m_8055_(p);
                Block block = state.m_60734_();
                if (state.m_60795_() || !(state.m_60800_((BlockGetter)this.world, p) >= 0.0f)) continue;
                switch (this.griefPreventionMethod) {
                    case NONE: {
                        block.m_7592_(this.world, p, ex);
                        this.world.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
                        break;
                    }
                    case GRIEF_DEFENDER: {
                        GriefDefenderHandler.destroyBlock(block, ex, p, this.world);
                        break;
                    }
                }
            }
            if (!this.cachedIterator.hasNext()) {
                WorldUtils.clearChunkCache();
                return true;
            }
        }
        float x = this.position.m_123341_();
        float y = this.position.m_123342_();
        float z = this.position.m_123343_();
        float size = (float)BallistixConstants.EXPLOSIVE_DARKMATTER_RADIUS;
        float doubleSize = size * 2.0f;
        int x0 = Mth.m_14107_((double)((double)x - (double)doubleSize - 1.0));
        int x1 = Mth.m_14107_((double)((double)x + (double)doubleSize + 1.0));
        int y0 = Mth.m_14107_((double)((double)y - (double)doubleSize - 1.0));
        int y1 = Mth.m_14107_((double)((double)y + (double)doubleSize + 1.0));
        int z0 = Mth.m_14107_((double)((double)z - (double)doubleSize - 1.0));
        int z1 = Mth.m_14107_((double)((double)z + (double)doubleSize + 1.0));
        List entities = this.world.m_45933_(null, new AABB((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1));
        block8: for (Entity entity : entities) {
            switch (this.griefPreventionMethod) {
                case GRIEF_DEFENDER: {
                    if (GriefDefenderHandler.shouldEntityBeHarmed(entity)) break;
                    continue block8;
                }
            }
            double deltaX = entity.m_20185_() - (double)x;
            double deltaY = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - (double)y;
            double deltaZ = entity.m_20189_() - (double)z;
            double deltaDistance = Mth.m_14116_((float)((float)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ)));
            if (deltaDistance == 0.0) continue;
            double d11 = (-0.2 - (double)(callCount - this.callAtStart) / 150.0) / deltaDistance;
            entity.m_20256_(entity.m_20184_().m_82520_((deltaX /= deltaDistance) * d11, (deltaY /= deltaDistance) * d11, (deltaZ /= deltaDistance) * d11));
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverplayerentity = (ServerPlayer)entity;
                if (serverplayerentity.m_7500_()) continue;
                serverplayerentity.f_8906_.m_9829_((Packet)new ClientboundExplodePacket((double)x, (double)y, (double)z, size, new ArrayList(), new Vec3(deltaX * d11, deltaY * d11, deltaZ * d11)));
                continue;
            }
            if (!(entity instanceof FallingBlockEntity)) continue;
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.attackEntities((float)((double)(callCount - this.callAtStart) / 75.0), ex);
        if ((double)this.world.f_46441_.m_188501_() < 0.5) {
            this.world.m_254849_(null, (double)this.position.m_123341_(), (double)this.position.m_123342_(), (double)this.position.m_123343_(), 2.0f, Level.ExplosionInteraction.NONE);
        }
        return false;
    }

    @Override
    public boolean isInstantaneous() {
        return false;
    }

    @Override
    public IBlast getBlastType() {
        return SubtypeBlast.darkmatter;
    }

    @Override
    public int movementTicks() {
        return BallistixConstants.EXPLOSIVE_DARKMATTER_MOVEMENTTICKS;
    }

    @Override
    public int persistenceTicks() {
        return BallistixConstants.EXPLOSIVE_DARKMATTER_PERSISTANCE;
    }
}

