/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.util;

import ballistix.api.blast.IBlast;
import ballistix.api.blast.IHasCustomRender;
import ballistix.api.blast.IMovingBlast;
import ballistix.api.event.BlastEvent;
import ballistix.common.entity.EntityBlast;
import ballistix.compatibility.griefdefender.GriefDefenderHandler;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;

public abstract class Blast {
    public static final HashMap<ResourceLocation, IBlast> BLAST_MAP = new HashMap();
    public static final HashMap<Item, IBlast> ITEM_TO_BLAST_MAP = new HashMap();
    public static final HashMap<IBlast, Item> BLAST_TO_GRENADE_MAP = new HashMap();
    public static final HashMap<IBlast, Item> BLAST_TO_MINECART_MAP = new HashMap();
    public BlockPos position;
    public Level world;
    public boolean hasStarted;
    public final GriefPreventionMethod griefPreventionMethod;
    public boolean shouldRenderCustomClient;
    public boolean isRepeating = false;

    protected Blast(Level world, BlockPos position) {
        this.world = world;
        this.position = position;
        this.griefPreventionMethod = Blast.getGriefPreventionMethod();
    }

    public static GriefPreventionMethod getGriefPreventionMethod() {
        if (ModList.get().isLoaded("griefdefender")) {
            return GriefPreventionMethod.GRIEF_DEFENDER;
        }
        return GriefPreventionMethod.NONE;
    }

    public boolean isInstantaneous() {
        return true;
    }

    public abstract IBlast getBlastType();

    public void doPreExplode() {
    }

    public boolean doExplode(int callCount) {
        Blast blast;
        if (this.world.f_46443_ && (this.shouldRenderCustomClient || this.isInstantaneous()) && (blast = this) instanceof IHasCustomRender) {
            IHasCustomRender renderer = (IHasCustomRender)((Object)blast);
            renderer.produceParticles();
        }
        return false;
    }

    public void doPostExplode() {
    }

    @Deprecated(since="Should not be called externally!", forRemoval=false)
    public final void preExplode() {
        BlastEvent.PreBlastEvent evt = new BlastEvent.PreBlastEvent(this.world, this);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (!evt.isCanceled()) {
            this.doPreExplode();
        }
    }

    @Deprecated(since="Should not be called externally!", forRemoval=false)
    public final boolean explode(int callcount) {
        BlastEvent evt = new BlastEvent(this.world, this);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (!evt.isCanceled()) {
            return this.doExplode(callcount);
        }
        return true;
    }

    @Deprecated(since="Should not be called externally!", forRemoval=false)
    public final void postExplode() {
        BlastEvent.PostBlastEvent evt = new BlastEvent.PostBlastEvent(this.world, this);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (!evt.isCanceled()) {
            this.doPostExplode();
        }
    }

    public EntityBlast performExplosion() {
        BlastEvent.ConstructBlastEvent evt = new BlastEvent.ConstructBlastEvent(this.world, this);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        Explosion explosion = new Explosion(this.world, null, null, null, (double)this.position.m_123341_(), (double)this.position.m_123342_(), (double)this.position.m_123343_(), 3.0f, true, Explosion.BlockInteraction.DESTROY);
        if (!ForgeEventFactory.onExplosionStart((Level)this.world, (Explosion)explosion) && !evt.isCanceled()) {
            if (this.isInstantaneous() && !(this instanceof IHasCustomRender)) {
                this.doPreExplode();
                this.doExplode(0);
                this.doPostExplode();
            } else if (!this.world.f_46443_) {
                EntityBlast entity = new EntityBlast(this.world);
                entity.m_6034_((double)this.position.m_123341_() + 0.5, (double)this.position.m_123342_() + 0.5, (double)this.position.m_123343_() + 0.5);
                entity.setBlastType(this.getBlastType());
                Blast blast = this;
                if (blast instanceof IMovingBlast) {
                    IMovingBlast moving = (IMovingBlast)((Object)blast);
                    entity.setPersistant(moving.persistenceTicks(), moving.movementTicks());
                }
                this.world.m_7967_((Entity)entity);
                return entity;
            }
        }
        return null;
    }

    protected void attackEntities(float size, Explosion explosion) {
        this.attackEntities(size, true, explosion);
    }

    protected void attackEntities(float size, boolean useRaytrace, Explosion explosion) {
        HashMap playerKnockbackMap = Maps.newHashMap();
        float doubleSize = size * 2.0f;
        int x0 = Mth.m_14107_((double)((double)this.position.m_123341_() - (double)doubleSize - 1.0));
        int x1 = Mth.m_14107_((double)((double)this.position.m_123341_() + (double)doubleSize + 1.0));
        int y0 = Mth.m_14107_((double)((double)this.position.m_123342_() - (double)doubleSize - 1.0));
        int y1 = Mth.m_14107_((double)((double)this.position.m_123342_() + (double)doubleSize + 1.0));
        int z0 = Mth.m_14107_((double)((double)this.position.m_123343_() - (double)doubleSize - 1.0));
        int z1 = Mth.m_14107_((double)((double)this.position.m_123343_() + (double)doubleSize + 1.0));
        List entities = this.world.m_45933_(null, new AABB((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1));
        Vec3 posVector = new Vec3((double)this.position.m_123341_(), (double)this.position.m_123342_(), (double)this.position.m_123343_());
        block4: for (Entity entity : entities) {
            Player playerentity;
            double deltaZ;
            double deltaY;
            boolean ignoreExplosion = entity.m_6128_();
            switch (this.griefPreventionMethod) {
                case NONE: {
                    if (!ignoreExplosion) break;
                    continue block4;
                }
                case GRIEF_DEFENDER: {
                    if (GriefDefenderHandler.shouldEntityBeHarmed(entity) || !ignoreExplosion) break;
                    continue block4;
                }
            }
            double normalizedDiameter = Mth.m_14116_((float)((float)entity.m_20238_(posVector))) / doubleSize;
            if (normalizedDiameter > 1.0) continue;
            double deltaX = entity.m_20185_() - (double)this.position.m_123341_();
            double deltaDistance = Mth.m_14116_((float)((float)(deltaX * deltaX + (deltaY = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - (double)this.position.m_123342_()) * deltaY + (deltaZ = entity.m_20189_() - (double)this.position.m_123343_()) * deltaZ)));
            if (deltaDistance == 0.0) continue;
            deltaX /= deltaDistance;
            deltaY /= deltaDistance;
            deltaZ /= deltaDistance;
            double seenAmount = useRaytrace ? (double)Explosion.m_46064_((Vec3)posVector, (Entity)entity) : 1.0;
            double damageAmount = (1.0 - normalizedDiameter) * seenAmount;
            entity.m_6469_(entity.m_269291_().m_269036_(null, null), (float)((int)((damageAmount * damageAmount + damageAmount) / 2.0 * 7.0 * (double)doubleSize + 1.0)));
            double actualDamange = damageAmount;
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                double damage = damageAmount;
                double i = ProtectionEnchantment.m_45135_((LivingEntity)le, (double)damageAmount);
                if (i > 0.0) {
                    damage *= Mth.m_14008_((double)(1.0 - i * 0.15), (double)0.0, (double)1.0);
                }
                actualDamange = damage;
            }
            entity.m_20256_(entity.m_20184_().m_82520_(deltaX * actualDamange, deltaY * actualDamange, deltaZ * actualDamange));
            if (!(entity instanceof Player) || (playerentity = (Player)entity).m_5833_() || playerentity.m_7500_() && playerentity.m_150110_().f_35935_) continue;
            playerKnockbackMap.put(playerentity, new Vec3(deltaX * damageAmount, deltaY * damageAmount, deltaZ * damageAmount));
        }
        for (Map.Entry entry : playerKnockbackMap.entrySet()) {
            Object k = entry.getKey();
            if (!(k instanceof ServerPlayer)) continue;
            ServerPlayer serverplayerentity = (ServerPlayer)k;
            serverplayerentity.f_8906_.m_9829_((Packet)new ClientboundExplodePacket((double)this.position.m_123341_(), (double)this.position.m_123342_(), (double)this.position.m_123343_(), size, new ArrayList(), (Vec3)entry.getValue()));
        }
    }

    public static enum GriefPreventionMethod {
        NONE,
        GRIEF_DEFENDER,
        SABER_FACTIONS;

    }

    public static interface BlastFactory<T extends Blast> {
        public T create(Level var1, BlockPos var2);
    }
}

