/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.item;

import ballistix.api.silo.ILauncherControlPanel;
import ballistix.api.silo.ILauncherPlatform;
import ballistix.api.silo.SiloRegistry;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.silo.TileLauncherControlPanelT1;
import ballistix.prefab.utils.BallistixTextUtils;
import ballistix.registers.BallistixCreativeTabs;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import voltaic.api.multiblock.subnodebased.TileMultiSubnode;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.item.ItemElectric;
import voltaic.prefab.utilities.math.MathUtils;
import voltaic.prefab.utilities.object.Location;
import voltaic.prefab.utilities.object.TransferPack;

public class ItemLaserDesignator
extends ItemElectric {
    public static final double USAGE = 150.0;
    public static final String FREQUENCY_KEY = "freq";

    public ItemLaserDesignator() {
        super((ElectricItemProperties)new ElectricItemProperties().capacity(1666666.66667).receive(TransferPack.joulesVoltage((double)694.4444444458333, (double)120.0)).extract(TransferPack.joulesVoltage((double)694.4444444458333, (double)120.0)).m_41487_(1), BallistixCreativeTabs.MAIN, item -> Items.f_41852_);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        TileMultiSubnode node;
        BlockEntity core;
        ILauncherControlPanel s;
        ILauncherControlPanel silo;
        BlockEntity ent = context.m_43725_().m_7702_(context.m_8083_());
        ILauncherControlPanel iLauncherControlPanel = silo = ent instanceof ILauncherControlPanel ? (s = (ILauncherControlPanel)ent) : null;
        if (ent instanceof TileMultiSubnode && (core = (node = (TileMultiSubnode)ent).m_58904_().m_7702_((BlockPos)node.parentPos.getValue())) instanceof ILauncherControlPanel) {
            ILauncherControlPanel c;
            silo = c = (ILauncherControlPanel)core;
        }
        if (silo != null && !context.m_43725_().f_46443_) {
            context.m_43723_().m_5661_((Component)BallistixTextUtils.chatMessage("laserdesignator.setfrequency", silo.getFrequency()), false);
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128405_(FREQUENCY_KEY, silo.getFrequency());
        }
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (worldIn.f_46443_) {
            return super.m_7203_(worldIn, playerIn, handIn);
        }
        ItemStack designator = playerIn.m_21120_(handIn);
        if (this.getJoulesStored(designator) < 150.0 || !designator.m_41784_().m_128441_(FREQUENCY_KEY)) {
            return super.m_7203_(worldIn, playerIn, handIn);
        }
        Location trace = MathUtils.getRaytracedBlock((Entity)playerIn);
        if (trace == null) {
            return super.m_7203_(worldIn, playerIn, handIn);
        }
        BlockEntity tile = trace.getTile((BlockGetter)worldIn);
        if (tile instanceof ILauncherControlPanel || tile instanceof TileMultiSubnode) {
            return InteractionResultHolder.m_19098_((Object)playerIn.m_21120_(handIn));
        }
        int frequency = ItemLaserDesignator.getFrequency(designator);
        BlockPos target = trace.toBlockPos();
        for (ILauncherControlPanel silo : SiloRegistry.getSilos(frequency, worldIn)) {
            ILauncherPlatform platform = silo.getPlatform();
            if (platform == null) continue;
            int range = platform.getRange();
            double distance = TileLauncherControlPanelT1.calculateDistance(silo.getPos(), target);
            if (range == 0 || range > 0 && (double)range < distance || distance > (double)BallistixConstants.LASER_DESIGNATOR_RANGE) continue;
            silo.setTargetFromDesignator(trace.toBlockPos());
            silo.launch();
            this.extractPower(designator, 150.0, false);
        }
        playerIn.m_5661_((Component)BallistixTextUtils.chatMessage("laserdesignator.launch", frequency), false);
        playerIn.m_5661_((Component)BallistixTextUtils.chatMessage("laserdesignator.launchsend", trace.toString()), false);
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.f_46443_ || !isSelected) {
            return;
        }
        Location trace = MathUtils.getRaytracedBlock((Entity)entityIn);
        if (trace == null) {
            return;
        }
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            player.m_5661_((Component)BallistixTextUtils.chatMessage("radargun.text", trace.toBlockPos().m_123344_()), true);
        }
    }

    public void m_7373_(ItemStack stack, Level context, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, context, tooltip, flagIn);
        if (stack.m_41782_() && stack.m_41783_().m_128441_(FREQUENCY_KEY)) {
            tooltip.add((Component)BallistixTextUtils.tooltip("laserdesignator.frequency", ItemLaserDesignator.getFrequency(stack)).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)BallistixTextUtils.tooltip("laserdesignator.nofrequency", new Object[0]).m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)BallistixTextUtils.tooltip("laserdesignator.signalrange", Component.m_237113_((String)("" + BallistixConstants.LASER_DESIGNATOR_RANGE)).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
    }

    public static int getFrequency(ItemStack stack) {
        return stack.m_41784_().m_128451_(FREQUENCY_KEY);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }
}

