/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.tile;

import ballistix.common.inventory.container.ContainerProximityDetector;
import ballistix.common.settings.BallistixConstants;
import ballistix.common.tile.turret.GenericTileTurret;
import ballistix.registers.BallistixItems;
import ballistix.registers.BallistixTiles;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.ListProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentForgeEnergy;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileProximityDetector
extends GenericTile {
    public final ListProperty<String> whitelistedPlayers = (ListProperty)this.property((AbstractProperty)new ListProperty(PropertyTypes.STRING_LIST, "whitelistedplayers", new ArrayList()));
    public final SingleProperty<Integer> entityTargetingMode = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "entitytargetingmode", (Object)0));
    public final SingleProperty<Boolean> usingWhitelist = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "usingwhitelist", (Object)false));
    public final SingleProperty<BlockPos> minCorner = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "mincorner", (Object)BlockPos.f_121853_));
    public final SingleProperty<BlockPos> maxCorner = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "maxcorner", (Object)BlockPos.f_121853_));
    public final SingleProperty<Integer> redstoneSignal = ((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "redstonesignal", (Object)0))).onChange((prop, old) -> {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }).onTileLoaded(prop -> {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
    });

    public TileProximityDetector(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)BallistixTiles.TILE_PROXIMITYDETECTOR.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).voltage(120.0).maxJoules(BallistixConstants.PROXIMITYDETECTOR_USAGEPERTICK * 20.0));
        this.addComponent((IComponent)new ComponentForgeEnergy((GenericTile)this));
        this.addComponent((IComponent)new ComponentContainerProvider("proximitydetector", (GenericTile)this).createMenu((id, inv) -> new ContainerProximityDetector((int)id, (Inventory)inv, (Container)new SimpleContainer(0), (ContainerData)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable componentTickable) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < BallistixConstants.PROXIMITYDETECTOR_USAGEPERTICK) {
            this.redstoneSignal.setValue((Object)0);
            return;
        }
        GenericTileTurret.TargetingMode mode = GenericTileTurret.TargetingMode.values()[(Integer)this.entityTargetingMode.getValue()];
        if (mode == GenericTileTurret.TargetingMode.NONE) {
            this.redstoneSignal.setValue((Object)0);
            return;
        }
        electro.joules(electro.getJoulesStored() - BallistixConstants.PROXIMITYDETECTOR_USAGEPERTICK);
        AABB box = new AABB(this.m_58899_().m_121955_((Vec3i)((BlockPos)this.minCorner.getValue()).m_142393_(-1)), this.m_58899_().m_121955_((Vec3i)this.maxCorner.getValue()).m_7918_(1, 1, 1));
        if (((Boolean)this.usingWhitelist.getValue()).booleanValue()) {
            if (((List)this.whitelistedPlayers.getValue()).isEmpty()) {
                this.redstoneSignal.setValue((Object)0);
                return;
            }
            List players = this.f_58857_.m_45976_(Player.class, box);
            if (players.isEmpty()) {
                this.redstoneSignal.setValue((Object)0);
                return;
            }
            for (Player player : players) {
                ItemStack inHand;
                if (!player.m_6084_() || ((inHand = player.m_21120_(InteractionHand.MAIN_HAND)).m_41619_() ? !(inHand = player.m_21120_(InteractionHand.OFF_HAND)).m_41619_() && inHand.m_150930_((Item)BallistixItems.ITEM_SCANNER.get()) : inHand.m_150930_((Item)BallistixItems.ITEM_SCANNER.get()))) continue;
                for (String name : (List)this.whitelistedPlayers.getValue()) {
                    if (!player.m_7755_().getString().equals(name)) continue;
                    this.redstoneSignal.setValue((Object)15);
                    return;
                }
            }
            this.redstoneSignal.setValue((Object)0);
        } else {
            Class type = mode == GenericTileTurret.TargetingMode.ONLY_PLAYERS ? Player.class : LivingEntity.class;
            List entities = this.f_58857_.m_45976_(type, box);
            if (entities.isEmpty()) {
                this.redstoneSignal.setValue((Object)0);
                return;
            }
            for (LivingEntity entity : entities) {
                ItemStack inHand;
                if (!entity.m_6084_() || (!(inHand = entity.m_21120_(InteractionHand.MAIN_HAND)).m_41619_() ? inHand.m_150930_((Item)BallistixItems.ITEM_SCANNER.get()) : !(inHand = entity.m_21120_(InteractionHand.OFF_HAND)).m_41619_() && inHand.m_150930_((Item)BallistixItems.ITEM_SCANNER.get()))) continue;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    boolean whitelisted = false;
                    for (String name : (List)this.whitelistedPlayers.getValue()) {
                        if (!player.m_7755_().getString().equals(name)) continue;
                        whitelisted = true;
                        break;
                    }
                    if (whitelisted) continue;
                    this.redstoneSignal.setValue((Object)15);
                    return;
                }
                this.redstoneSignal.setValue((Object)15);
                return;
            }
            this.redstoneSignal.setValue((Object)0);
        }
    }

    public void setPlacedBy(LivingEntity player, ItemStack stack) {
        super.setPlacedBy(player, stack);
        if (player instanceof Player) {
            Player pl = (Player)player;
            this.whitelistedPlayers.addValue((Object)pl.m_7755_().getString());
        }
    }

    public int getSignal(Direction dir) {
        return (Integer)this.redstoneSignal.getValue();
    }
}

