/*
 * Decompiled with CFR 0.152.
 */
package ballistix.prefab.screen;

import ballistix.client.screen.ScreenFireControlRadar;
import ballistix.common.inventory.container.ContainerFireControlRadar;
import ballistix.common.tile.radar.TileFireControlRadar;
import ballistix.prefab.BallistixIconTypes;
import ballistix.prefab.screen.ScreenComponentFrequency;
import ballistix.prefab.utils.BallistixTextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import voltaic.api.screen.ITexture;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.ScreenComponentVerticalSlider;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGuiTab;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.math.Color;

public class WrapperFireControlFrequencyManager {
    private final ScreenFireControlRadar screen;
    public ScreenComponentButton<?> button;
    private ScreenComponentButton<?> toggleButton;
    private ScreenComponentButton<?> add;
    private ScreenComponentSimpleLabel whitelistLabel;
    private ScreenComponentButton[] deleteButtons = new ScreenComponentButton[5];
    private ScreenComponentFrequency[] frequencies = new ScreenComponentFrequency[5];
    public ScreenComponentEditBox addEditBox;
    private int topRowIndex = 0;
    private int lastRowCount = 0;
    private static final int BUTTON_COUNT = 5;

    public WrapperFireControlFrequencyManager(ScreenFireControlRadar screen, int tabX, int tabY, int x, int y) {
        int i;
        this.screen = screen;
        this.button = (ScreenComponentButton)new ScreenComponentButton((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, tabX, tabY).setOnPress(button -> {
            boolean bl = button.isPressed = !button.isPressed;
            if (button.isPressed) {
                this.updateVisibility(true);
                screen.slider.setVisible(true);
                screen.trackingLabel.setVisible(false);
                screen.radarGrid.setVisible(false);
            } else {
                this.updateVisibility(false);
                screen.slider.setVisible(false);
                screen.trackingLabel.setVisible(true);
                screen.radarGrid.setVisible(true);
            }
        }).onTooltip((graphics, but, xAxis, yAxis) -> {
            ScreenComponentButton button = (ScreenComponentButton)but;
            ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
            tooltips.add(BallistixTextUtils.tooltip("radar.frequencymanager", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY));
            if (!button.isPressed) {
                tooltips.add(VoltaicTextUtils.tooltip((String)"inventoryio.presstoshow", (Object[])new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            } else {
                tooltips.add(VoltaicTextUtils.tooltip((String)"inventoryio.presstohide", (Object[])new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
            graphics.m_280666_(screen.getFontRenderer(), tooltips, xAxis, yAxis);
        }).setIcon((ITexture)BallistixIconTypes.FREQUENCY);
        screen.addComponent((AbstractScreenComponent)this.button);
        this.whitelistLabel = new ScreenComponentSimpleLabel(x + 15, y + 30, 10, Color.TEXT_GRAY, (Component)BallistixTextUtils.gui("radar.frequencywhitelist.mode", new Object[0]));
        screen.addComponent((AbstractScreenComponent)this.whitelistLabel);
        this.toggleButton = new ScreenComponentButton(x + 90, y + 25, 70, 20).setOnPress(button -> {
            TileFireControlRadar radar = (TileFireControlRadar)((ContainerFireControlRadar)screen.m_6262_()).getSafeHost();
            if (radar == null) {
                return;
            }
            radar.usingWhitelist.setValue((Object)((Boolean)radar.usingWhitelist.getValue() == false ? 1 : 0));
        }).setLabel(() -> {
            TileFireControlRadar radar = (TileFireControlRadar)((ContainerFireControlRadar)screen.m_6262_()).getSafeHost();
            if (radar == null) {
                return Component.m_237119_();
            }
            return (Boolean)radar.usingWhitelist.getValue() != false ? BallistixTextUtils.gui("radar.frequencywhitelist.enabled", new Object[0]) : BallistixTextUtils.gui("radar.frequencywhitelist.disabled", new Object[0]);
        });
        screen.addComponent((AbstractScreenComponent)this.toggleButton);
        this.add = new ScreenComponentButton(x + 90, y + 50, 70, 20).setOnPress(button -> {
            TileFireControlRadar radar = (TileFireControlRadar)((ContainerFireControlRadar)screen.m_6262_()).getSafeHost();
            if (radar == null) {
                return;
            }
            try {
                int freq = Integer.parseInt(this.addEditBox.getValue());
                radar.whitelistedFrequencies.addValue((Object)freq);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).setLabel((Component)BallistixTextUtils.gui("radar.frequencywhitelist.add", new Object[0]));
        screen.addComponent((AbstractScreenComponent)this.add);
        this.addEditBox = new ScreenComponentEditBox(x + 15, y + 52, 70, 15, screen.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(9).setFilter(ScreenComponentEditBox.INTEGER);
        screen.addEditBox(this.addEditBox);
        int butOffX = 25;
        int butOffY = 80;
        for (i = 0; i < 5; ++i) {
            this.frequencies[i] = new ScreenComponentFrequency(x + butOffX, y + butOffY + 15 * i, 125, 15);
        }
        for (i = 0; i < 5; ++i) {
            int index = i;
            this.deleteButtons[i] = (ScreenComponentButton)new ScreenComponentButton(x + butOffX + 125, y + butOffY + 15 * i, 15, 15).setOnPress(but -> {
                ScreenComponentFrequency frequency = this.frequencies[index];
                TileFireControlRadar tile = (TileFireControlRadar)((ContainerFireControlRadar)screen.m_6262_()).getSafeHost();
                if (frequency.getFrequency() == null) {
                    return;
                }
                tile.whitelistedFrequencies.removeValue(frequency.getFrequency().intValue());
            }).onTooltip((graphics, button, xAxis, yAxis) -> graphics.m_280557_(screen.getFontRenderer(), (Component)BallistixTextUtils.tooltip("radar.frequencymanager.delete", new Object[0]), xAxis, yAxis)).setIcon((ITexture)BallistixIconTypes.DELETE);
        }
        screen.addComponent((AbstractScreenComponent)this.button);
        screen.addComponent((AbstractScreenComponent)this.toggleButton);
        screen.addComponent((AbstractScreenComponent)this.add);
        screen.addComponent((AbstractScreenComponent)this.whitelistLabel);
        screen.addComponent((AbstractScreenComponent)this.addEditBox);
        for (i = 0; i < 5; ++i) {
            screen.addComponent((AbstractScreenComponent)this.frequencies[i]);
        }
        for (i = 0; i < 5; ++i) {
            screen.addComponent((AbstractScreenComponent)this.deleteButtons[i]);
        }
        this.updateVisibility(false);
    }

    public void tick() {
        TileFireControlRadar tile = (TileFireControlRadar)((ContainerFireControlRadar)this.screen.m_6262_()).getSafeHost();
        if (tile == null) {
            return;
        }
        List frequencyList = (List)tile.whitelistedFrequencies.getValue();
        this.lastRowCount = frequencyList.size();
        for (int i = 0; i < 5; ++i) {
            ScreenComponentFrequency button = this.frequencies[i];
            int index = this.topRowIndex + i;
            if (index < frequencyList.size()) {
                button.setFrequency((Integer)frequencyList.get(index));
                continue;
            }
            button.setFrequency(null);
        }
        ScreenComponentVerticalSlider slider = this.screen.slider;
        if (this.lastRowCount > 5) {
            slider.updateActive(true);
            if (!slider.isSliderHeld()) {
                int moveRoom = this.screen.slider.height - 15 - 2;
                double moved = (double)this.topRowIndex / ((double)this.lastRowCount - 5.0);
                slider.setSliderYOffset((int)((double)moveRoom * moved));
            }
        } else {
            slider.updateActive(false);
            slider.setSliderYOffset(0);
            this.topRowIndex = 0;
        }
    }

    public void handleMouseScroll(int dir) {
        if (Screen.m_96637_()) {
            dir *= 4;
        }
        int lastRowIndex = this.lastRowCount - 1;
        if (this.lastRowCount > 5) {
            if (this.topRowIndex >= this.lastRowCount) {
                this.topRowIndex = lastRowIndex - 4;
            }
            this.topRowIndex = Mth.m_14045_((int)(this.topRowIndex += dir), (int)0, (int)(lastRowIndex - 4));
        } else {
            this.topRowIndex = 0;
        }
    }

    public Consumer<Integer> getSliderClickedConsumer() {
        return mouseY -> {
            ScreenComponentVerticalSlider slider = this.screen.slider;
            if (slider.isSliderActive()) {
                int sliderY = slider.yLocation;
                int sliderHeight = slider.height;
                int mouseHeight = mouseY - sliderY;
                if (mouseHeight >= sliderHeight - 2 - 15) {
                    this.topRowIndex = this.lastRowCount - 5;
                    slider.setSliderYOffset(sliderHeight - 2 - 15);
                } else if (mouseHeight <= 2) {
                    this.topRowIndex = 0;
                    slider.setSliderYOffset(0);
                } else {
                    double heightRatio = (double)mouseHeight / (double)sliderHeight;
                    this.topRowIndex = (int)Math.round((double)(this.lastRowCount - 5) * heightRatio);
                    int moveRoom = slider.height - 15 - 2;
                    double moved = (double)this.topRowIndex / ((double)this.lastRowCount - 5.0);
                    slider.setSliderYOffset((int)((double)moveRoom * moved));
                }
            }
        };
    }

    public Consumer<Integer> getSliderDraggedConsumer() {
        return mouseY -> {
            ScreenComponentVerticalSlider slider = this.screen.slider;
            if (slider.isSliderActive()) {
                int sliderY = slider.yLocation;
                int sliderHeight = slider.height;
                if (mouseY <= sliderY + 2) {
                    this.topRowIndex = 0;
                    slider.setSliderYOffset(0);
                } else if (mouseY >= sliderY + sliderHeight - 2 - 15) {
                    this.topRowIndex = this.lastRowCount - 5;
                    slider.setSliderYOffset(sliderHeight - 2 - 15);
                } else {
                    int mouseHeight = mouseY - sliderY;
                    slider.setSliderYOffset(mouseHeight);
                    double heightRatio = (double)mouseHeight / (double)sliderHeight;
                    this.topRowIndex = (int)Math.round((double)(this.lastRowCount - 5) * heightRatio);
                }
            }
        };
    }

    public void updateVisibility(boolean show) {
        this.toggleButton.setVisible(show);
        this.add.setVisible(show);
        this.whitelistLabel.setVisible(show);
        for (ScreenComponentFrequency screenComponentFrequency : this.frequencies) {
            screenComponentFrequency.setVisible(show);
        }
        for (ScreenComponentFrequency screenComponentFrequency : this.deleteButtons) {
            screenComponentFrequency.setVisible(show);
        }
        this.addEditBox.setVisible(show);
        this.addEditBox.setValue("");
    }
}

