/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.extensions.IForgeFriendlyByteBuf;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.recipebook.FermentingRecipeBookTab;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.common.registry.BnCRecipeSerializers;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.BnCRecipeUtils;
import umpaz.brewinandchewin.common.utility.KegRecipeWrapper;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;

public class KegFermentingRecipe
implements Recipe<KegRecipeWrapper> {
    public static final int INPUT_SLOTS = 4;
    private final ResourceLocation id;
    private final NonNullList<Ingredient> inputItems;
    @Nullable
    private final FermentingRecipeBookTab tab;
    @Nullable
    private final FluidStack fluidIngredient;
    @Nullable
    private final Fluid resultFluid;
    @Nullable
    private final Item resultItem;
    private final float experience;
    private final int fermentTime;
    private final int temperature;
    private final int amount;

    public KegFermentingRecipe(ResourceLocation id, NonNullList<Ingredient> inputItems, FermentingRecipeBookTab tab, @Nullable FluidStack fluidIngredient, @Nullable Fluid resultFluid, @Nullable Item resultItem, int amount, float experience, int fermentTime, int temperature) {
        this.id = id;
        this.inputItems = inputItems;
        this.tab = tab;
        this.fluidIngredient = fluidIngredient;
        this.resultFluid = resultFluid;
        this.resultItem = resultItem;
        this.amount = amount;
        this.experience = experience;
        this.fermentTime = fermentTime;
        this.temperature = temperature;
    }

    @Nullable
    public FermentingRecipeBookTab getRecipeBookTab() {
        return this.tab;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    @Nullable
    public FluidStack getFluidIngredient() {
        return this.fluidIngredient;
    }

    @Nullable
    public Fluid getResultFluid() {
        return this.resultFluid;
    }

    @Nullable
    public Item getResultItem() {
        return this.resultItem;
    }

    public int getAmount() {
        return this.amount;
    }

    public ItemStack assemble(KegRecipeWrapper inv, RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getFermentTime() {
        return this.fermentTime;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public boolean matches(KegRecipeWrapper inv, Level level) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < 4; ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            inputs.add(itemstack);
        }
        return i == this.inputItems.size() && RecipeMatcher.findMatches(inputs, this.inputItems) != null && (this.fluidIngredient == null && inv.getFluid(0).isEmpty() || this.fluidIngredient != null && !inv.getFluid(0).isEmpty() && inv.getFluid(0).isFluidEqual(this.fluidIngredient) && inv.getFluid(0).getAmount() % this.amount == 0);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        if (this.resultItem != null) {
            return this.resultItem.m_7968_().m_255036_(this.amount);
        }
        if (this.resultFluid != null) {
            return BnCRecipeUtils.getPouredItemFromFluid(new FluidStack(this.resultFluid, ((Integer)BnCConfiguration.KEG_CAPACITY.get()).intValue()));
        }
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)BnCRecipeSerializers.FERMENTING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)BnCRecipeTypes.FERMENTING.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)BnCItems.KEG.get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KegFermentingRecipe that = (KegFermentingRecipe)o;
        if (Float.compare(that.getExperience(), this.getExperience()) != 0) {
            return false;
        }
        if (this.getFermentTime() != that.getFermentTime()) {
            return false;
        }
        if (this.getTemperature() != that.getTemperature()) {
            return false;
        }
        if (!this.m_6423_().equals((Object)that.m_6423_())) {
            return false;
        }
        if (this.getResultFluid() != that.getResultFluid()) {
            return false;
        }
        if (this.getResultItem() != that.getResultItem()) {
            return false;
        }
        if (this.getFluidIngredient() != that.getFluidIngredient()) {
            return false;
        }
        if (this.getAmount() != that.getAmount()) {
            return false;
        }
        return this.inputItems.equals(that.inputItems);
    }

    public int hashCode() {
        int result = this.m_6423_().hashCode();
        result = 31 * result + this.inputItems.hashCode();
        result = 31 * result + (this.fluidIngredient != null ? this.fluidIngredient.hashCode() : 0);
        result = 31 * result + (this.resultItem != null ? this.resultItem.hashCode() : 0);
        result = 31 * result + (this.resultFluid != null ? this.resultFluid.hashCode() : 0);
        result = 31 * result + (this.getExperience() != 0.0f ? Float.floatToIntBits(this.getExperience()) : 0);
        result = 31 * result + this.getFermentTime();
        result = 31 * result + this.getTemperature();
        return result;
    }

    public static class Serializer
    implements RecipeSerializer<KegFermentingRecipe> {
        public KegFermentingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList<Ingredient> inputItemsIn = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (inputItemsIn.isEmpty()) {
                throw new JsonParseException("No ingredients for cooking recipe");
            }
            if (inputItemsIn.size() > 4) {
                throw new JsonParseException("Too many ingredients for cooking recipe! The max is 4");
            }
            String tabKeyIn = GsonHelper.m_13851_((JsonObject)json, (String)"recipe_book_tab", null);
            FermentingRecipeBookTab tabIn = FermentingRecipeBookTab.findByName(tabKeyIn);
            if (tabKeyIn != null && tabIn == null) {
                BrewinAndChewin.LOG.warn("Optional field 'recipe_book_tab' does not match any valid tab. If defined, must be one of the following: " + String.valueOf(EnumSet.allOf(CookingPotRecipeBookTab.class)));
            }
            FluidStack baseFluidStackIn = null;
            if (json.has("basefluid")) {
                JsonObject baseFluid = json.getAsJsonObject("basefluid");
                baseFluidStackIn = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)baseFluid, (String)"fluid"))), GsonHelper.m_13824_((JsonObject)baseFluid, (String)"count", (int)200));
            }
            float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            int fermentingTime = GsonHelper.m_13824_((JsonObject)json, (String)"fermentingtime", (int)200);
            int temperature = GsonHelper.m_13824_((JsonObject)json, (String)"temperature", (int)3);
            JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            int count = GsonHelper.m_13927_((JsonObject)result, (String)"count");
            Fluid resultFluid = null;
            if (result.has("fluid")) {
                resultFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)result, (String)"fluid")));
            }
            Item resultItem = null;
            if (result.has("item")) {
                resultItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)result, (String)"item")));
            }
            return new KegFermentingRecipe(recipeId, inputItemsIn, tabIn, baseFluidStackIn, resultFluid, resultItem, count, experience, fermentingTime, temperature);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public KegFermentingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            NonNullList inputItemsIn = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < inputItemsIn.size(); ++j) {
                inputItemsIn.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            Optional tabIn = buffer.m_236860_(friendlyByteBuf -> (FermentingRecipeBookTab)friendlyByteBuf.m_130066_(FermentingRecipeBookTab.class));
            Optional baseFluidStackIn = buffer.m_236860_(IForgeFriendlyByteBuf::readFluidStack);
            Optional<Item> itemResult = buffer.m_236860_(FriendlyByteBuf::m_130267_).map(ItemStack::m_41720_);
            Optional<Fluid> fluidResult = buffer.m_236860_(IForgeFriendlyByteBuf::readFluidStack).map(FluidStack::getFluid);
            int amount = buffer.readInt();
            float experienceIn = buffer.readFloat();
            int fermentTimeIn = buffer.m_130242_();
            int temperatureIn = buffer.m_130242_();
            return new KegFermentingRecipe(recipeId, (NonNullList<Ingredient>)inputItemsIn, tabIn.orElse(null), baseFluidStackIn.orElse(null), fluidResult.orElse(null), itemResult.orElse(null), amount, experienceIn, fermentTimeIn, temperatureIn);
        }

        public void toNetwork(FriendlyByteBuf buffer, KegFermentingRecipe recipe) {
            buffer.m_130130_(recipe.inputItems.size());
            for (Ingredient ingredient : recipe.inputItems) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_236835_(recipe.tab != null ? Optional.of(recipe.tab) : Optional.empty(), FriendlyByteBuf::m_130068_);
            buffer.m_236835_(recipe.fluidIngredient != null ? Optional.of(recipe.fluidIngredient) : Optional.empty(), IForgeFriendlyByteBuf::writeFluidStack);
            buffer.m_236835_(recipe.resultItem != null ? Optional.of(recipe.resultItem.m_7968_()) : Optional.empty(), FriendlyByteBuf::m_130055_);
            buffer.m_236835_(recipe.resultFluid != null ? Optional.of(new FluidStack(recipe.resultFluid, 1)) : Optional.empty(), IForgeFriendlyByteBuf::writeFluidStack);
            buffer.writeInt(recipe.amount);
            buffer.writeFloat(recipe.experience);
            buffer.m_130130_(recipe.fermentTime);
            buffer.m_130130_(recipe.temperature);
        }
    }
}

