/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.shape;

import java.util.Arrays;
import java.util.List;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.platform.util.Vector2;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.ShapeUtil;

public class Diamond
extends AbstractPolygon {
    final double p1x;
    final double p1z;
    final double p2x;
    final double p2z;
    final double p3x;
    final double p3z;
    final double p4x;
    final double p4z;

    public Diamond(Selection selection, boolean chunkAligned) {
        super(selection, chunkAligned);
        this.p1x = this.centerX;
        this.p1z = this.centerZ + this.radiusX;
        this.p2x = this.centerX - this.radiusX;
        this.p2z = this.centerZ;
        this.p3x = this.centerX;
        this.p3z = this.centerZ - this.radiusX;
        this.p4x = this.centerX + this.radiusX;
        this.p4z = this.centerZ;
    }

    @Override
    public List<Vector2> points() {
        return Arrays.asList(Vector2.of(this.p1x, this.p1z), Vector2.of(this.p2x, this.p2z), Vector2.of(this.p3x, this.p3z), Vector2.of(this.p4x, this.p4z));
    }

    @Override
    public boolean isBounding(double x, double z) {
        if (!ShapeUtil.insideLine(this.p1x, this.p1z, this.p2x, this.p2z, x, z)) {
            return false;
        }
        if (!ShapeUtil.insideLine(this.p2x, this.p2z, this.p3x, this.p3z, x, z)) {
            return false;
        }
        if (!ShapeUtil.insideLine(this.p3x, this.p3z, this.p4x, this.p4z, x, z)) {
            return false;
        }
        return ShapeUtil.insideLine(this.p4x, this.p4z, this.p1x, this.p1z, x, z);
    }

    @Override
    public String name() {
        return "diamond";
    }
}

