/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.data.registry;

import dev.corgitaco.dataanchor.data.TrackedData;
import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TrackedDataRegistry<O, T extends TrackedData<O>> {
    public static final Map<ResourceLocation, TrackedDataRegistry<?, ?>> REGISTRIES = new HashMap();
    private final Map<TrackedDataKey<T>, TrackedDataFactory<O, T>> factories = new Reference2ObjectOpenHashMap();
    private final Set<ResourceLocation> usedIds = new HashSet<ResourceLocation>();
    private final ResourceLocation id;

    private TrackedDataRegistry(ResourceLocation id) {
        this.id = id;
    }

    public static <O, T extends TrackedData<O>> TrackedDataRegistry<O, T> of(ResourceLocation id) {
        TrackedDataRegistry trackedDataRegistry = REGISTRIES.computeIfAbsent(id, key -> new TrackedDataRegistry(id));
        return trackedDataRegistry;
    }

    public <F extends T, K extends TrackedDataKey<F>> void register(K key, TrackedDataFactory<O, F> factory) {
        if (this.factories.get(key) != null) {
            throw new IllegalArgumentException("TrackedDataKey already registered in Tracked Data Registry \"%s\"!");
        }
        ResourceLocation id = key.getId();
        if (this.usedIds.contains(id)) {
            throw new IllegalArgumentException("TrackedDataKey with id \"%s\" already registered in Tracked Data Registry \"%s\"!".formatted(id, this.id));
        }
        this.factories.put(key, factory);
        this.usedIds.add(id);
    }

    public <E extends T> Optional<E> get(TrackedDataKey<E> key, O o) {
        if (o instanceof TrackedDataContainer) {
            TrackedDataContainer trackedDataContainer = (TrackedDataContainer)o;
            return trackedDataContainer.dataAnchor$getTrackedData(key);
        }
        return Optional.empty();
    }

    @Nullable
    public TrackedDataContainer<O, T> getContainer(O o) {
        if (o instanceof TrackedDataContainer) {
            TrackedDataContainer trackedDataContainer = (TrackedDataContainer)o;
            return trackedDataContainer;
        }
        return null;
    }

    public Map<TrackedDataKey<T>, TrackedDataFactory<O, T>> factories() {
        return this.factories;
    }

    public <E extends T> TrackedDataKey<E> register(ResourceLocation id, Class<E> clazz, TrackedDataFactory<O, E> factory) {
        Object key = TrackedDataKey.of(this, clazz, id);
        if (this.factories.get(key) == null) {
            this.register((TrackedDataKey)key, (TrackedDataFactory)factory);
        }
        return key;
    }

    @FunctionalInterface
    public static interface TrackedDataFactory<T, D extends TrackedData<T>> {
        @Nullable
        public D create(TrackedDataKey<D> var1, T var2);
    }
}

