/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.screen.tile;

import electrodynamics.common.inventory.container.tile.ContainerCircuitMonitor;
import electrodynamics.common.tile.electricitygrid.TileCircuitMonitor;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnit;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentMultiLabel;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.math.Color;

public class ScreenCircuitMonitor
extends GenericScreen<ContainerCircuitMonitor> {
    private ScreenComponentEditBox value;
    private boolean needsUpdate = true;

    public ScreenCircuitMonitor(ContainerCircuitMonitor container, Inventory inv, Component title) {
        super((GenericContainer)container, inv, title);
        this.f_97727_ += 40;
        this.addComponent((AbstractScreenComponent)new ScreenComponentMultiLabel(0, 0, graphics -> {
            TileCircuitMonitor monitor = (TileCircuitMonitor)((ContainerCircuitMonitor)this.f_97732_).getSafeHost();
            if (monitor == null) {
                return;
            }
            DisplayUnit units = ScreenCircuitMonitor.getUnit((Integer)monitor.networkProperty.getValue());
            MutableComponent combined = ScreenCircuitMonitor.getPropertyLabel((Integer)monitor.networkProperty.getValue()).m_130946_(" ").m_7220_((Component)ScreenCircuitMonitor.getOperatorLabel((Integer)monitor.booleanOperator.getValue())).m_130946_(" ").m_7220_((Component)ChatFormatter.getChatDisplayShort((double)((Double)monitor.value.getValue()), (IDisplayUnit)units)).m_130940_(ChatFormatting.BOLD);
            int offset = (int)((double)(150 - this.f_96547_.m_92852_((FormattedText)combined)) / 2.0);
            graphics.m_280614_(this.f_96547_, (Component)combined, 13 + offset, 22, 0, false);
            Component symbol = units.getSymbol();
            graphics.m_280614_(this.f_96547_, symbol, 163 - this.f_96547_.m_92852_((FormattedText)symbol), 175, Color.TEXT_GRAY.color(), false);
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(13, 38, 10, Color.TEXT_GRAY, (Component)ElectroTextUtils.gui("property", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(13, 118, 10, Color.TEXT_GRAY, (Component)ElectroTextUtils.gui("operator", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(13, 158, 10, Color.TEXT_GRAY, (Component)ElectroTextUtils.gui("value", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(13, 50, 70, 20).setLabel((Component)ScreenCircuitMonitor.getPropertyLabel(0)).setOnPress(button -> {
            TileCircuitMonitor monitor = (TileCircuitMonitor)((ContainerCircuitMonitor)this.f_97732_).getSafeHost();
            if (monitor == null) {
                return;
            }
            monitor.networkProperty.setValue((Object)0);
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(13, 70, 70, 20).setLabel((Component)ScreenCircuitMonitor.getPropertyLabel(1)).setOnPress(button -> {
            TileCircuitMonitor monitor = (TileCircuitMonitor)((ContainerCircuitMonitor)this.f_97732_).getSafeHost();
            if (monitor == null) {
                return;
            }
            monitor.networkProperty.setValue((Object)1);
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(13, 90, 70, 20).setLabel((Component)ScreenCircuitMonitor.getPropertyLabel(2)).setOnPress(button -> {
            TileCircuitMonitor monitor = (TileCircuitMonitor)((ContainerCircuitMonitor)this.f_97732_).getSafeHost();
            if (monitor == null) {
                return;
            }
            monitor.networkProperty.setValue((Object)2);
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(93, 50, 70, 20).setLabel((Component)ScreenCircuitMonitor.getPropertyLabel(3)).setOnPress(button -> {
            TileCircuitMonitor monitor = (TileCircuitMonitor)((ContainerCircuitMonitor)this.f_97732_).getSafeHost();
            if (monitor == null) {
                return;
            }
            monitor.networkProperty.setValue((Object)3);
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(93, 70, 70, 20).setLabel((Component)ScreenCircuitMonitor.getPropertyLabel(4)).setOnPress(button -> {
            TileCircuitMonitor monitor = (TileCircuitMonitor)((ContainerCircuitMonitor)this.f_97732_).getSafeHost();
            if (monitor == null) {
                return;
            }
            monitor.networkProperty.setValue((Object)4);
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(93, 90, 70, 20).setLabel((Component)ScreenCircuitMonitor.getPropertyLabel(5)).setOnPress(button -> {
            TileCircuitMonitor monitor = (TileCircuitMonitor)((ContainerCircuitMonitor)this.f_97732_).getSafeHost();
            if (monitor == null) {
                return;
            }
            monitor.networkProperty.setValue((Object)5);
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(13, 130, 20, 20).setLabel((Component)ScreenCircuitMonitor.getOperatorLabel(0)).setOnPress(button -> {
            TileCircuitMonitor monitor = (TileCircuitMonitor)((ContainerCircuitMonitor)this.f_97732_).getSafeHost();
            if (monitor == null) {
                return;
            }
            monitor.booleanOperator.setValue((Object)0);
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(39, 130, 20, 20).setLabel((Component)ScreenCircuitMonitor.getOperatorLabel(1)).setOnPress(button -> {
            TileCircuitMonitor monitor = (TileCircuitMonitor)((ContainerCircuitMonitor)this.f_97732_).getSafeHost();
            if (monitor == null) {
                return;
            }
            monitor.booleanOperator.setValue((Object)1);
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(65, 130, 20, 20).setLabel((Component)ScreenCircuitMonitor.getOperatorLabel(2)).setOnPress(button -> {
            TileCircuitMonitor monitor = (TileCircuitMonitor)((ContainerCircuitMonitor)this.f_97732_).getSafeHost();
            if (monitor == null) {
                return;
            }
            monitor.booleanOperator.setValue((Object)2);
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(91, 130, 20, 20).setLabel((Component)ScreenCircuitMonitor.getOperatorLabel(3)).setOnPress(button -> {
            TileCircuitMonitor monitor = (TileCircuitMonitor)((ContainerCircuitMonitor)this.f_97732_).getSafeHost();
            if (monitor == null) {
                return;
            }
            monitor.booleanOperator.setValue((Object)3);
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(117, 130, 20, 20).setLabel((Component)ScreenCircuitMonitor.getOperatorLabel(4)).setOnPress(button -> {
            TileCircuitMonitor monitor = (TileCircuitMonitor)((ContainerCircuitMonitor)this.f_97732_).getSafeHost();
            if (monitor == null) {
                return;
            }
            monitor.booleanOperator.setValue((Object)4);
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(143, 130, 20, 20).setLabel((Component)ScreenCircuitMonitor.getOperatorLabel(5)).setOnPress(button -> {
            TileCircuitMonitor monitor = (TileCircuitMonitor)((ContainerCircuitMonitor)this.f_97732_).getSafeHost();
            if (monitor == null) {
                return;
            }
            monitor.booleanOperator.setValue((Object)5);
        }));
        this.value = new ScreenComponentEditBox(13, 170, 134, 20, this.getFontRenderer()).setFilter(ScreenComponentEditBox.POSITIVE_DECIMAL).setMaxLength(30).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setResponder(this::handleValue);
        this.addEditBox(this.value);
        this.playerInvLabel.setVisible(false);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            TileCircuitMonitor monitor = (TileCircuitMonitor)((ContainerCircuitMonitor)this.f_97732_).getSafeHost();
            if (monitor != null) {
                this.value.setValue("" + monitor.value.getValue());
            }
        }
    }

    private void handleValue(String val) {
        if (val == null || val.isEmpty()) {
            return;
        }
        TileCircuitMonitor monitor = (TileCircuitMonitor)((ContainerCircuitMonitor)this.f_97732_).getSafeHost();
        if (monitor == null) {
            return;
        }
        double value = 0.0;
        try {
            value = Double.parseDouble(val);
        }
        catch (Exception exception) {
            // empty catch block
        }
        monitor.value.setValue((Object)value);
    }

    private static MutableComponent getPropertyLabel(int label) {
        return switch (label) {
            case 0 -> ElectroTextUtils.gui("networkwattage", new Object[0]);
            case 1 -> ElectroTextUtils.gui("networkvoltage", new Object[0]);
            case 2 -> ElectroTextUtils.gui("networkampacity", new Object[0]);
            case 3 -> ElectroTextUtils.gui("networkminimumvoltage", new Object[0]);
            case 4 -> ElectroTextUtils.gui("networkresistance", new Object[0]);
            case 5 -> ElectroTextUtils.gui("networkload", new Object[0]);
            default -> Component.m_237119_();
        };
    }

    private static MutableComponent getOperatorLabel(int label) {
        return switch (label) {
            case 0 -> ElectroTextUtils.gui("equals", new Object[0]);
            case 1 -> ElectroTextUtils.gui("notequals", new Object[0]);
            case 2 -> ElectroTextUtils.gui("lessthan", new Object[0]);
            case 3 -> ElectroTextUtils.gui("greaterthan", new Object[0]);
            case 4 -> ElectroTextUtils.gui("lessthanorequalto", new Object[0]);
            case 5 -> ElectroTextUtils.gui("greaterthanorequalto", new Object[0]);
            default -> Component.m_237119_();
        };
    }

    private static DisplayUnit getUnit(int label) {
        return switch (label) {
            case 0, 5 -> DisplayUnits.WATT;
            case 1, 3 -> DisplayUnits.VOLTAGE;
            case 2 -> DisplayUnits.AMPERE;
            case 4 -> DisplayUnits.RESISTANCE;
            default -> DisplayUnits.WATT;
        };
    }
}

