/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.armor.types;

import electrodynamics.client.ElectrodynamicsClientRegister;
import electrodynamics.client.model.armor.ModelServoLeggings;
import electrodynamics.common.item.gear.armor.ICustomArmor;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import electrodynamics.registers.ElectrodynamicsItems;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.item.IItemElectric;
import voltaic.common.item.gear.ItemVoltaicArmor;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.utilities.VoltaicTextUtils;

public class ItemServoLeggings
extends ItemVoltaicArmor
implements IItemElectric {
    public static final int JOULES_PER_TICK = 5;
    public static final int DURATION_SECONDS = 1;
    public static final float DEFAULT_VANILLA_STEPUP = 0.6f;
    private static final String ARMOR_TEXTURE = "electrodynamics:textures/model/armor/servoleggings.png";
    final ElectricItemProperties properties;

    public ItemServoLeggings(ElectricItemProperties properties, Supplier<CreativeModeTab> creativeTab) {
        super((ArmorMaterial)ServoLeggings.SERVOLEGGINGS, ArmorItem.Type.LEGGINGS, (Item.Properties)properties, creativeTab);
        this.properties = properties;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> properties) {
                ModelServoLeggings model = new ModelServoLeggings(ElectrodynamicsClientRegister.SERVO_LEGGINGS.m_171564_());
                model.f_102817_ = properties.f_102817_;
                model.f_102609_ = properties.f_102609_;
                model.f_102610_ = properties.f_102610_;
                return model;
            }
        });
    }

    public ElectricItemProperties getElectricProperties() {
        return this.properties;
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean m_41465_() {
        return false;
    }

    public int m_142158_(ItemStack stack) {
        return (int)Math.round(13.0 * this.getJoulesStored(stack) / this.getMaximumCapacity(stack));
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getJoulesStored(stack) < this.getMaximumCapacity(stack);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, world, tooltip, flagIn);
        tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.info", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)this.getJoulesStored(stack), (IDisplayUnit)DisplayUnits.JOULES), (Component)ChatFormatter.getChatDisplayShort((double)this.getMaximumCapacity(stack), (IDisplayUnit)DisplayUnits.JOULES)).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.voltage", ChatFormatter.getChatDisplayShort((double)this.properties.receive.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        ItemServoLeggings.staticAppendTooltips(stack, world, tooltip, flagIn);
    }

    protected static void staticAppendTooltips(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            if (tag.m_128471_("on")) {
                tooltip.add((Component)ElectroTextUtils.tooltip("nightvisiongoggles.status", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("nightvisiongoggles.on", new Object[0]).m_130940_(ChatFormatting.GREEN)));
            } else {
                tooltip.add((Component)ElectroTextUtils.tooltip("nightvisiongoggles.status", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("nightvisiongoggles.off", new Object[0]).m_130940_(ChatFormatting.RED)));
            }
            tooltip.add(ItemServoLeggings.getModeText(tag.m_128451_("mode")));
        } else {
            tooltip.add((Component)ElectroTextUtils.tooltip("nightvisiongoggles.status", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("nightvisiongoggles.off", new Object[0]).m_130940_(ChatFormatting.RED)));
            tooltip.add((Component)ElectroTextUtils.tooltip("jetpack.mode", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("servolegs.none", new Object[0]).m_130940_(ChatFormatting.RED)));
        }
        IItemElectric.addBatteryTooltip((ItemStack)stack, (Level)world, tooltip);
    }

    public static Component getModeText(int mode) {
        return switch (mode) {
            case 0 -> ElectroTextUtils.tooltip("jetpack.mode", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("servolegs.step", new Object[0]).m_130940_(ChatFormatting.GREEN));
            case 1 -> ElectroTextUtils.tooltip("jetpack.mode", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("servolegs.both", new Object[0]).m_130940_(ChatFormatting.AQUA));
            case 2 -> ElectroTextUtils.tooltip("jetpack.mode", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("servolegs.speed", new Object[0]).m_130940_(ChatFormatting.GREEN));
            case 3 -> ElectroTextUtils.tooltip("jetpack.mode", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("servolegs.none", new Object[0]).m_130940_(ChatFormatting.RED));
            default -> Component.m_237113_((String)"");
        };
    }

    public void addCreativeModeItems(CreativeModeTab group, List<ItemStack> items) {
        ItemStack empty = new ItemStack((ItemLike)this);
        IItemElectric.setEnergyStored((ItemStack)empty, (double)0.0);
        items.add(empty);
        ItemStack charged = new ItemStack((ItemLike)this);
        IItemElectric.setEnergyStored((ItemStack)charged, (double)this.getMaximumCapacity(charged));
        items.add(charged);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        super.onArmorTick(stack, world, player);
        ItemServoLeggings.armorTick(stack, world, player);
    }

    protected static void armorTick(ItemStack stack, Level world, Player player) {
        block16: {
            CompoundTag tag;
            block17: {
                block14: {
                    CompoundTag tag2;
                    block15: {
                        if (world.f_46443_) break block14;
                        IItemElectric legs = (IItemElectric)stack.m_41720_();
                        tag2 = stack.m_41784_();
                        if (!tag2.m_128471_("on") || !(legs.getJoulesStored(stack) >= 5.0)) break block15;
                        switch (tag2.m_128451_("mode")) {
                            case 0: {
                                tag2.m_128379_("reset", false);
                                tag2.m_128379_("sucess", true);
                                player.m_274367_(1.1f);
                                legs.extractPower(stack, 5.0, false);
                                break;
                            }
                            case 1: {
                                tag2.m_128379_("reset", false);
                                tag2.m_128379_("sucess", true);
                                player.m_274367_(1.1f);
                                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 20, 0, false, false, false));
                                legs.extractPower(stack, 5.0, false);
                                break;
                            }
                            case 2: {
                                tag2.m_128379_("reset", false);
                                tag2.m_128379_("sucess", false);
                                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 20, 0, false, false, false));
                                legs.extractPower(stack, 5.0, false);
                                break;
                            }
                            case 3: {
                                tag2.m_128379_("sucess", false);
                                if (!tag2.m_128471_("reset")) {
                                    player.m_274367_(0.6f);
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block16;
                    }
                    tag2.m_128379_("sucess", false);
                    if (!tag2.m_128471_("reset")) {
                        player.m_274367_(0.6f);
                    }
                    break block16;
                }
                if (!stack.m_41782_()) break block16;
                tag = stack.m_41783_();
                if (!tag.m_128471_("sucess")) break block17;
                switch (tag.m_128451_("mode")) {
                    case 0: 
                    case 1: {
                        player.m_274367_(1.1f);
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (!tag.m_128471_("reset")) {
                            player.m_274367_(0.6f);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block16;
            }
            if (!tag.m_128471_("reset")) {
                player.m_274367_(0.6f);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return ARMOR_TEXTURE;
    }

    public Item getDefaultStorageBattery() {
        return (Item)ElectrodynamicsItems.ITEM_BATTERY.get();
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (!IItemElectric.overrideOtherStackedOnMe((ItemStack)stack, (ItemStack)other, (Slot)slot, (ClickAction)action, (Player)player, (SlotAccess)access)) {
            return super.m_142305_(stack, other, slot, action, player, access);
        }
        return true;
    }

    public static enum ServoLeggings implements ICustomArmor
    {
        SERVOLEGGINGS;


        public SoundEvent m_7344_() {
            return SoundEvents.f_11677_;
        }

        public String m_6082_() {
            return "electrodynamics:servoleggings";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }

        public int m_266425_(ArmorItem.Type pType) {
            return 100;
        }

        public int m_7366_(ArmorItem.Type pType) {
            return 1;
        }
    }
}

