/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.packet.types.server;

import electrodynamics.registers.ElectrodynamicsItems;
import electrodynamics.registers.ElectrodynamicsSounds;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import voltaic.api.item.IItemElectric;
import voltaic.prefab.utilities.ItemUtils;

public class PacketToggleOnServer {
    private final UUID playerId;
    private final Type type;

    public PacketToggleOnServer(UUID uuid, Type type) {
        this.playerId = uuid;
        this.type = type;
    }

    public static void handle(PacketToggleOnServer message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerLevel world = ((NetworkEvent.Context)context.get()).getSender().m_284548_();
            if (world != null) {
                Player player = world.m_46003_(message.playerId);
                switch (message.type) {
                    case NVGS: {
                        CompoundTag tag;
                        ItemStack playerHead = player.m_6844_(EquipmentSlot.HEAD);
                        if (!ItemUtils.testItems((Item)playerHead.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_NIGHTVISIONGOGGLES.get()}) && !ItemUtils.testItems((Item)playerHead.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_COMBATHELMET.get()})) break;
                        tag.m_128379_("on", !(tag = playerHead.m_41784_()).m_128471_("on"));
                        if (!(((IItemElectric)playerHead.m_41720_()).getJoulesStored(playerHead) >= 5.0)) break;
                        if (tag.m_128471_("on")) {
                            player.m_6330_((SoundEvent)ElectrodynamicsSounds.SOUND_NIGHTVISIONGOGGLESON.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                            break;
                        }
                        player.m_6330_((SoundEvent)ElectrodynamicsSounds.SOUND_NIGHTVISIONGOGGLESOFF.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        break;
                    }
                    case SERVOLEGGINGS: {
                        CompoundTag tag;
                        ItemStack playerLegs = player.m_6844_(EquipmentSlot.LEGS);
                        if (!ItemUtils.testItems((Item)playerLegs.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_SERVOLEGGINGS.get()}) && !ItemUtils.testItems((Item)playerLegs.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_COMBATLEGGINGS.get()})) break;
                        tag.m_128379_("on", !(tag = playerLegs.m_41784_()).m_128471_("on"));
                        player.m_6330_((SoundEvent)ElectrodynamicsSounds.SOUND_JETPACKSWITCHMODE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        break;
                    }
                }
            }
        });
    }

    public static void encode(PacketToggleOnServer message, FriendlyByteBuf buf) {
        buf.m_130077_(message.playerId);
        buf.m_130068_((Enum)message.type);
    }

    public static PacketToggleOnServer decode(FriendlyByteBuf buf) {
        return new PacketToggleOnServer(buf.m_130259_(), (Type)buf.m_130066_(Type.class));
    }

    public static enum Type {
        NVGS,
        SERVOLEGGINGS;

    }
}

