/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid;

import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import voltaic.Voltaic;
import voltaic.api.electricity.ICapabilityElectrodynamic;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.object.TransferPack;
import voltaic.registers.VoltaicCapabilities;

public class TileCircuitBreaker
extends GenericTile {
    public static final int TRIP_CURVE = 20;
    private boolean recievedRedstoneSignal = false;
    private boolean tripped = false;
    private int tripCurveTimer = 0;
    private boolean isLocked = false;
    public static final BlockEntityUtils.MachineDirection OUTPUT = BlockEntityUtils.MachineDirection.FRONT;
    public static final BlockEntityUtils.MachineDirection INPUT = BlockEntityUtils.MachineDirection.BACK;

    public TileCircuitBreaker(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_CIRCUITBREAKER.get(), worldPosition, blockState);
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, true).receivePower(this::receivePower).getConnectedLoad(this::getConnectedLoad).setOutputDirections(new BlockEntityUtils.MachineDirection[]{OUTPUT}).setInputDirections(new BlockEntityUtils.MachineDirection[]{INPUT}).voltage(-1.0).getAmpacity(this::getAmpacity).getMinimumVoltage(this::getMinimumVoltage));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
    }

    public void tickServer(ComponentTickable tickable) {
        if (this.tripCurveTimer > 0) {
            --this.tripCurveTimer;
            return;
        }
        if (this.tripped) {
            this.f_58857_.m_247517_(null, this.m_58899_(), SoundEvents.f_12011_, SoundSource.BLOCKS);
        }
        this.tripped = false;
    }

    public TransferPack receivePower(TransferPack transfer, boolean debug) {
        if (this.recievedRedstoneSignal || this.isLocked || this.tripped) {
            return TransferPack.EMPTY;
        }
        Direction output = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)TileCircuitBreaker.OUTPUT.mappedDir);
        BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_121945_(output));
        if (tile == null) {
            return TransferPack.EMPTY;
        }
        this.isLocked = true;
        ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)tile.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, output.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
        if (electro == CapabilityUtils.EMPTY_ELECTRO) {
            this.isLocked = false;
            return TransferPack.EMPTY;
        }
        if (electro.getMinimumVoltage() > -1.0 && electro.getMinimumVoltage() < transfer.getVoltage()) {
            this.tripped = true;
            this.tripCurveTimer = 20;
            this.f_58857_.m_247517_(null, this.m_58899_(), SoundEvents.f_12012_, SoundSource.BLOCKS);
            this.isLocked = false;
            return transfer;
        }
        if (electro.getAmpacity() > 0.0 && electro.getAmpacity() < transfer.getAmpsInTicks()) {
            Voltaic.LOGGER.info("tripped");
            this.tripped = true;
            this.tripCurveTimer = 20;
            this.f_58857_.m_247517_(null, this.m_58899_(), SoundEvents.f_12012_, SoundSource.BLOCKS);
            this.isLocked = false;
            return transfer;
        }
        if (debug) {
            TransferPack accepted = electro.receivePower(TransferPack.joulesVoltage((double)(transfer.getJoules() * (double)ElectroConstants.CIRCUITBREAKER_EFFICIENCY), (double)transfer.getVoltage()), debug);
            this.isLocked = false;
            if (accepted.getJoules() > 0.0) {
                return TransferPack.joulesVoltage((double)(accepted.getJoules() / (double)ElectroConstants.CIRCUITBREAKER_EFFICIENCY), (double)accepted.getVoltage());
            }
            return TransferPack.EMPTY;
        }
        TransferPack accepted = electro.receivePower(TransferPack.joulesVoltage((double)(transfer.getJoules() * (double)ElectroConstants.CIRCUITBREAKER_EFFICIENCY), (double)transfer.getVoltage()), debug);
        this.isLocked = false;
        return TransferPack.joulesVoltage((double)(accepted.getJoules() / (double)ElectroConstants.CIRCUITBREAKER_EFFICIENCY), (double)accepted.getVoltage());
    }

    public TransferPack getConnectedLoad(ICapabilityElectrodynamic.LoadProfile lastEnergy, Direction dir) {
        if (this.recievedRedstoneSignal || this.isLocked || this.tripped) {
            return TransferPack.EMPTY;
        }
        Direction output = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)TileCircuitBreaker.OUTPUT.mappedDir);
        if (dir != output.m_122424_()) {
            return TransferPack.EMPTY;
        }
        BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_121945_(output));
        if (tile == null) {
            return TransferPack.EMPTY;
        }
        this.isLocked = true;
        ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)tile.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, output.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
        if (electro == CapabilityUtils.EMPTY_ELECTRO) {
            this.isLocked = false;
            return TransferPack.EMPTY;
        }
        if (electro.getMinimumVoltage() > -1.0 && (electro.getMinimumVoltage() < lastEnergy.lastUsage().getVoltage() || electro.getMinimumVoltage() < lastEnergy.maximumAvailable().getVoltage())) {
            this.tripped = true;
            this.tripCurveTimer = 20;
            this.f_58857_.m_247517_(null, this.m_58899_(), SoundEvents.f_12012_, SoundSource.BLOCKS);
            this.isLocked = false;
            return TransferPack.EMPTY;
        }
        if (electro.getAmpacity() > 0.0 && electro.getAmpacity() <= lastEnergy.lastUsage().getAmpsInTicks()) {
            this.tripped = true;
            this.tripCurveTimer = 20;
            this.f_58857_.m_247517_(null, this.m_58899_(), SoundEvents.f_12012_, SoundSource.BLOCKS);
            this.isLocked = false;
            return TransferPack.EMPTY;
        }
        ICapabilityElectrodynamic.LoadProfile transformed = new ICapabilityElectrodynamic.LoadProfile(TransferPack.joulesVoltage((double)(lastEnergy.lastUsage().getJoules() * (double)ElectroConstants.CIRCUITBREAKER_EFFICIENCY), (double)lastEnergy.lastUsage().getVoltage()), TransferPack.joulesVoltage((double)(lastEnergy.maximumAvailable().getJoules() * (double)ElectroConstants.CIRCUITBREAKER_EFFICIENCY), (double)lastEnergy.maximumAvailable().getVoltage()));
        this.isLocked = true;
        TransferPack returner = electro.getConnectedLoad(transformed, dir);
        this.isLocked = false;
        return TransferPack.joulesVoltage((double)(returner.getJoules() / (double)ElectroConstants.CIRCUITBREAKER_EFFICIENCY), (double)returner.getVoltage());
    }

    public double getMinimumVoltage() {
        Direction facing = this.getFacing();
        if (this.isLocked) {
            return 0.0;
        }
        BlockEntity output = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing));
        if (output == null) {
            return -1.0;
        }
        this.isLocked = true;
        ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)output.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, facing.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
        if (electro == CapabilityUtils.EMPTY_ELECTRO) {
            this.isLocked = false;
            return -1.0;
        }
        double minimumVoltage = electro.getMinimumVoltage();
        this.isLocked = false;
        return minimumVoltage;
    }

    public double getAmpacity() {
        Direction facing = this.getFacing();
        if (this.isLocked) {
            return 0.0;
        }
        BlockEntity output = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing));
        if (output == null) {
            return -1.0;
        }
        this.isLocked = true;
        ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)output.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, facing.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
        if (electro == CapabilityUtils.EMPTY_ELECTRO) {
            this.isLocked = false;
            return -1.0;
        }
        double ampacity = electro.getAmpacity();
        this.isLocked = false;
        return ampacity;
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("hasredstonesignal", this.recievedRedstoneSignal);
        compound.m_128379_("tripped", this.tripped);
        compound.m_128405_("timer", this.tripCurveTimer);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.recievedRedstoneSignal = compound.m_128471_("hasredstonesignal");
        this.tripped = compound.m_128471_("tripped");
        this.tripCurveTimer = compound.m_128451_("timer");
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.recievedRedstoneSignal = this.f_58857_.m_276867_(this.m_58899_());
        if (BlockEntityUtils.isLit((GenericTile)this) ^ this.recievedRedstoneSignal) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)this.recievedRedstoneSignal);
            if (this.recievedRedstoneSignal) {
                this.f_58857_.m_247517_(null, this.m_58899_(), SoundEvents.f_12012_, SoundSource.BLOCKS);
            } else {
                this.f_58857_.m_247517_(null, this.m_58899_(), SoundEvents.f_12011_, SoundSource.BLOCKS);
            }
        }
    }

    public void onPlace(BlockState oldState, boolean isMoving) {
        super.onPlace(oldState, isMoving);
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.recievedRedstoneSignal = this.f_58857_.m_276867_(this.m_58899_());
        if (BlockEntityUtils.isLit((GenericTile)this) ^ this.recievedRedstoneSignal) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)this.recievedRedstoneSignal);
            if (this.recievedRedstoneSignal) {
                this.f_58857_.m_247517_(null, this.m_58899_(), SoundEvents.f_12012_, SoundSource.BLOCKS);
            }
        }
    }
}

