/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid.generators;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerCombustionChamber;
import electrodynamics.common.reloadlistener.CombustionFuelRegister;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.prefab.utilities.ElectricityUtils;
import electrodynamics.prefab.utilities.object.CombustionFuelSource;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import voltaic.api.electricity.generator.IElectricGenerator;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.common.network.utils.FluidUtilities;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.tile.types.GenericMaterialTile;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileCombustionChamber
extends GenericMaterialTile
implements IElectricGenerator,
ITickableSound {
    public static final int TICKS_PER_MILLIBUCKET = 200;
    public static final int TANK_CAPACITY = 1000;
    public SingleProperty<Boolean> running = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "running", (Object)false));
    public SingleProperty<Integer> burnTime = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "burnTime", (Object)0));
    private double fuelMultiplier = 1.0;
    private CachedTileOutput output;
    private SingleProperty<Double> multiplier = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "multiplier", (Object)1.0));
    private SingleProperty<Boolean> hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "redstonesignal", (Object)false));
    private boolean isSoundPlaying = false;

    public TileCombustionChamber(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_COMBUSTIONCHAMBER.get(), worldPosition, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, false).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.RIGHT}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().bucketInputs(1)).valid((slot, stack, i) -> stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM) != null));
        this.addComponent((IComponent)new ComponentFluidHandlerMulti((GenericTile)this).setInputTanks(1, new int[]{1000}).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT}).setInputFluidTags(CombustionFuelRegister.INSTANCE.getFluidTags()));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.combustionchamber.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerCombustionChamber((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    protected void tickServer(ComponentTickable tickable) {
        if (((Boolean)this.hasRedstoneSignal.getValue()).booleanValue()) {
            this.running.setValue((Object)false);
            return;
        }
        Direction facing = this.getFacing();
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(facing.m_122427_()));
        }
        if (tickable.getTicks() % 40L == 0L) {
            this.output.update(this.f_58858_.m_121945_(facing.m_122427_()));
        }
        ComponentFluidHandlerMulti handler = (ComponentFluidHandlerMulti)this.getComponent(IComponentType.FluidHandler);
        FluidUtilities.drainItem((GenericTile)this, (FluidTank[])handler.getInputTanks());
        PropertyFluidTank tank = handler.getInputTanks()[0];
        if ((Integer)this.burnTime.getValue() <= 0) {
            CombustionFuelSource source;
            this.running.setValue((Object)false);
            if (tank.getFluidAmount() > 0 && !(source = CombustionFuelRegister.INSTANCE.getFuelFromFluid(tank.getFluid())).isEmpty()) {
                tank.drain(new FluidStack(tank.getFluid().getFluid(), source.getFuelUsage()), IFluidHandler.FluidAction.EXECUTE);
                this.fuelMultiplier = source.getPowerMultiplier();
                this.running.setValue((Object)true);
                this.burnTime.setValue((Object)200);
            }
        } else {
            this.running.setValue((Object)true);
        }
        if ((Integer)this.burnTime.getValue() > 0) {
            this.burnTime.setValue((Object)((Integer)this.burnTime.getValue() - 1));
        }
        if (((Boolean)this.running.getValue()).booleanValue() && (Integer)this.burnTime.getValue() > 0 && this.output.valid()) {
            ElectricityUtils.receivePower((BlockEntity)this.output.getSafe(), facing.m_122427_().m_122424_(), this.getProduced(), false);
        }
    }

    protected void tickClient(ComponentTickable tickable) {
        if (!((Boolean)this.running.getValue()).booleanValue()) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188500_() < 0.15) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + this.f_58857_.f_46441_.m_188500_(), (double)this.f_58858_.m_123342_() + this.f_58857_.f_46441_.m_188500_(), (double)this.f_58858_.m_123343_() + this.f_58857_.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
        }
        if (!this.isSoundPlaying) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_COMBUSTIONCHAMBER.get()), (BlockEntity)this, (boolean)true);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Boolean)this.running.getValue();
    }

    public void setMultiplier(double val) {
        this.multiplier.setValue((Object)val);
    }

    public double getMultiplier() {
        return (Double)this.multiplier.getValue();
    }

    public TransferPack getProduced() {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        return TransferPack.joulesVoltage((double)(ElectroConstants.COMBUSTIONCHAMBER_JOULES_PER_TICK * this.fuelMultiplier * (Double)this.multiplier.getValue()), (double)electro.getVoltage());
    }

    public int getComparatorSignal() {
        return (Boolean)this.running.getValue() != false ? 15 : 0;
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.hasRedstoneSignal.setValue((Object)this.f_58857_.m_276867_(this.m_58899_()));
    }
}

